/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.EmailUtil;
import jodd.mail.MailServer;
import jodd.mail.ReceiveMailSession;

public class Pop3Server
extends MailServer<ReceiveMailSession> {
    protected static final String MAIL_POP3_PORT = "mail.pop3.port";
    protected static final String MAIL_POP3_HOST = "mail.pop3.host";
    protected static final String MAIL_POP3_AUTH = "mail.pop3.auth";
    protected static final String PROTOCOL_POP3 = "pop3";
    protected static final int DEFAULT_POP3_PORT = 110;

    public Pop3Server(String host, int port, Authenticator authenticator, File attachmentStorage) {
        super(host, port == -1 ? 110 : port, authenticator, attachmentStorage);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty(MAIL_POP3_HOST, this.getHost());
        props.setProperty(MAIL_POP3_PORT, String.valueOf(this.getPort()));
        if (this.getAuthenticator() != null) {
            props.setProperty(MAIL_POP3_AUTH, "true");
        }
        return props;
    }

    protected Store getStore(Session session) throws NoSuchProviderException {
        return session.getStore(PROTOCOL_POP3);
    }

    @Override
    public ReceiveMailSession createSession() {
        return EmailUtil.createSession(PROTOCOL_POP3, this.getSessionProperties(), this.getAuthenticator(), this.getAttachmentStorage());
    }
}

