/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.paramo.MethodParameter;
import jodd.paramo.Paramo;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PetiteReferenceType;
import jodd.petite.def.BeanReferences;
import jodd.petite.meta.PetiteInject;
import jodd.typeconverter.Converter;
import jodd.util.StringUtil;

public class ReferencesResolver {
    private final PetiteConfig petiteConfig;

    public ReferencesResolver(PetiteConfig petiteConfig) {
        this.petiteConfig = petiteConfig;
    }

    public BeanReferences resolveReferenceFromValue(PropertyDescriptor propertyDescriptor, String refName) {
        BeanReferences references = refName == null || refName.isEmpty() ? this.buildDefaultReference(propertyDescriptor) : BeanReferences.of(refName);
        references = references.removeDuplicateNames();
        return references;
    }

    public BeanReferences[] resolveReferenceFromValues(Executable methodOrCtor, String ... parameterReferences) {
        BeanReferences[] references = this.convertRefToReferences(parameterReferences);
        if (references == null || references.length == 0) {
            references = this.buildDefaultReferences(methodOrCtor);
        }
        if (methodOrCtor.getParameterTypes().length != references.length) {
            throw new PetiteException("Different number of method parameters and references for: " + methodOrCtor.getDeclaringClass().getName() + '#' + methodOrCtor.getName());
        }
        this.removeAllDuplicateNames(references);
        return references;
    }

    public BeanReferences readReferenceFromAnnotation(PropertyDescriptor propertyDescriptor) {
        MethodDescriptor writeMethodDescriptor = propertyDescriptor.getWriteMethodDescriptor();
        FieldDescriptor fieldDescriptor = propertyDescriptor.getFieldDescriptor();
        PetiteInject ref = null;
        if (writeMethodDescriptor != null) {
            ref = writeMethodDescriptor.getMethod().getAnnotation(PetiteInject.class);
        }
        if (ref == null && fieldDescriptor != null) {
            ref = fieldDescriptor.getField().getAnnotation(PetiteInject.class);
        }
        if (ref == null) {
            return null;
        }
        BeanReferences reference = null;
        String name = ref.value().trim();
        if (name.length() != 0) {
            reference = BeanReferences.of(name);
        }
        reference = this.updateReferencesWithDefaultsIfNeeded(propertyDescriptor, reference);
        reference = reference.removeDuplicateNames();
        return reference;
    }

    public BeanReferences[] readAllReferencesFromAnnotation(Executable methodOrCtor) {
        boolean hasAnnotationOnMethodOrCtor;
        BeanReferences[] references;
        PetiteInject petiteInject = methodOrCtor.getAnnotation(PetiteInject.class);
        Parameter[] parameters = methodOrCtor.getParameters();
        if (petiteInject != null) {
            references = this.convertAnnValueToReferences(petiteInject.value());
            hasAnnotationOnMethodOrCtor = true;
        } else {
            references = new BeanReferences[parameters.length];
            hasAnnotationOnMethodOrCtor = false;
        }
        int parametersWithAnnotationCount = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            petiteInject = parameter.getAnnotation(PetiteInject.class);
            if (petiteInject == null) continue;
            String annotationValue = this.readAnnotationValue(petiteInject);
            if (annotationValue != null) {
                references[i] = BeanReferences.of(annotationValue);
            }
            ++parametersWithAnnotationCount;
        }
        if (!hasAnnotationOnMethodOrCtor) {
            if (parametersWithAnnotationCount == 0) {
                return null;
            }
            if (parametersWithAnnotationCount != parameters.length) {
                throw new PetiteException("All arguments must be annotated with PetiteInject");
            }
        }
        references = this.updateReferencesWithDefaultsIfNeeded(methodOrCtor, references);
        this.removeAllDuplicateNames(references);
        return references;
    }

    private String readAnnotationValue(PetiteInject annotation) {
        String value = annotation.value().trim();
        if (value.isEmpty()) {
            return null;
        }
        return value;
    }

    private BeanReferences[] updateReferencesWithDefaultsIfNeeded(Executable methodOrCtor, BeanReferences[] references) {
        BeanReferences[] defaultReferences = this.buildDefaultReferences(methodOrCtor);
        if (references == null || references.length == 0) {
            references = defaultReferences;
        }
        if (methodOrCtor.getParameterTypes().length != references.length) {
            throw new PetiteException("Different number of parameters and references for: " + methodOrCtor.getName());
        }
        for (int i = 0; i < references.length; ++i) {
            BeanReferences parameterReferences = references[i];
            if (!this.parameterReferenceIsNotSet(parameterReferences)) continue;
            references[i] = defaultReferences[i];
        }
        return references;
    }

    private BeanReferences updateReferencesWithDefaultsIfNeeded(PropertyDescriptor propertyDescriptor, BeanReferences references) {
        if (references == null || references.isEmpty()) {
            references = this.buildDefaultReference(propertyDescriptor);
        }
        return references;
    }

    private boolean parameterReferenceIsNotSet(BeanReferences parameterReferences) {
        if (parameterReferences == null) {
            return true;
        }
        return parameterReferences.isEmpty();
    }

    private BeanReferences[] buildDefaultReferences(Executable methodOrCtor) {
        boolean useParamo = this.petiteConfig.getUseParamo();
        PetiteReferenceType[] lookupReferences = this.petiteConfig.getLookupReferences();
        MethodParameter[] methodParameters = null;
        if (useParamo) {
            methodParameters = Paramo.resolveParameters(methodOrCtor);
        }
        Class<?>[] paramTypes = methodOrCtor.getParameterTypes();
        BeanReferences[] references = new BeanReferences[paramTypes.length];
        for (int j = 0; j < paramTypes.length; ++j) {
            String[] ref = new String[lookupReferences.length];
            references[j] = BeanReferences.of(ref);
            block6: for (int i = 0; i < ref.length; ++i) {
                switch (lookupReferences[i]) {
                    case NAME: {
                        ref[i] = methodParameters != null ? methodParameters[j].getName() : null;
                        continue block6;
                    }
                    case TYPE_SHORT_NAME: {
                        ref[i] = StringUtil.uncapitalize(paramTypes[j].getSimpleName());
                        continue block6;
                    }
                    case TYPE_FULL_NAME: {
                        ref[i] = paramTypes[j].getName();
                    }
                }
            }
        }
        return references;
    }

    public BeanReferences buildDefaultReference(PropertyDescriptor propertyDescriptor) {
        PetiteReferenceType[] lookupReferences = this.petiteConfig.getLookupReferences();
        String[] references = new String[lookupReferences.length];
        block5: for (int i = 0; i < references.length; ++i) {
            switch (lookupReferences[i]) {
                case NAME: {
                    references[i] = propertyDescriptor.getName();
                    continue block5;
                }
                case TYPE_SHORT_NAME: {
                    references[i] = StringUtil.uncapitalize(propertyDescriptor.getType().getSimpleName());
                    continue block5;
                }
                case TYPE_FULL_NAME: {
                    references[i] = propertyDescriptor.getType().getName();
                }
            }
        }
        return BeanReferences.of(references);
    }

    private void removeAllDuplicateNames(BeanReferences[] allBeanReferences) {
        for (int i = 0; i < allBeanReferences.length; ++i) {
            BeanReferences references = allBeanReferences[i];
            allBeanReferences[i] = references.removeDuplicateNames();
        }
    }

    private BeanReferences[] convertRefToReferences(String[] references) {
        if (references == null) {
            return null;
        }
        BeanReferences[] ref = new BeanReferences[references.length];
        for (int i = 0; i < references.length; ++i) {
            ref[i] = BeanReferences.of(references[i]);
        }
        return ref;
    }

    private BeanReferences[] convertAnnValueToReferences(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        String[] refNames = Converter.get().toStringArray(value);
        BeanReferences[] references = new BeanReferences[refNames.length];
        for (int i = 0; i < refNames.length; ++i) {
            references[i] = BeanReferences.of(refNames[i].trim());
        }
        return references;
    }
}

