/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.ArrayList;
import java.util.Map;
import jodd.exception.ExceptionUtil;
import jodd.http.Cookie;
import jodd.http.HeadersMultiMap;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpException;
import jodd.http.HttpMultiMap;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;

public class HttpBrowser {
    protected HttpConnectionProvider httpConnectionProvider;
    protected HttpRequest httpRequest;
    protected HttpResponse httpResponse;
    protected HttpMultiMap<Cookie> cookies = HttpMultiMap.newCaseInsensitiveMap();
    protected HeadersMultiMap defaultHeaders = new HeadersMultiMap();
    protected boolean keepAlive;
    protected long elapsedTime;
    protected boolean catchTransportExceptions = true;

    public HttpBrowser() {
        this.httpConnectionProvider = HttpConnectionProvider.get();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpBrowser setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public HttpBrowser setCatchTransportExceptions(boolean catchTransportExceptions) {
        this.catchTransportExceptions = catchTransportExceptions;
        return this;
    }

    public HttpBrowser setProxyInfo(ProxyInfo proxyInfo) {
        this.httpConnectionProvider.useProxy(proxyInfo);
        return this;
    }

    public HttpBrowser setHttpConnectionProvider(HttpConnectionProvider httpConnectionProvider) {
        this.httpConnectionProvider = httpConnectionProvider;
        return this;
    }

    public HttpBrowser setDefaultHeader(String name, String value) {
        this.defaultHeaders.addHeader(name, value);
        return this;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getPage() {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.bodyText();
    }

    public HttpResponse sendRequest(HttpRequest httpRequest) {
        this.elapsedTime = System.currentTimeMillis();
        httpRequest.followRedirects(false);
        while (true) {
            String newPath;
            this.httpRequest = httpRequest;
            HttpResponse previousResponse = this.httpResponse;
            this.httpResponse = null;
            this.addDefaultHeaders(httpRequest);
            this.addCookies(httpRequest);
            if (this.catchTransportExceptions) {
                try {
                    this.httpResponse = this._sendRequest(httpRequest, previousResponse);
                }
                catch (HttpException httpException) {
                    this.httpResponse = new HttpResponse();
                    this.httpResponse.assignHttpRequest(httpRequest);
                    this.httpResponse.statusCode(503);
                    this.httpResponse.statusPhrase("Service unavailable. " + ExceptionUtil.message(httpException));
                }
            } else {
                this.httpResponse = this._sendRequest(httpRequest, previousResponse);
            }
            this.readCookies(this.httpResponse);
            int statusCode = this.httpResponse.statusCode();
            if (statusCode == 301) {
                newPath = this.httpResponse.location();
                if (newPath == null) break;
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode == 302 || statusCode == 303) {
                newPath = this.httpResponse.location();
                if (newPath == null) break;
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode != 307 && statusCode != 308 || (newPath = this.httpResponse.location()) == null) break;
            String originalMethod = httpRequest.method();
            httpRequest = new HttpRequest().method(originalMethod).set(newPath);
        }
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
        return this.httpResponse;
    }

    protected HttpResponse _sendRequest(HttpRequest httpRequest, HttpResponse previouseResponse) {
        if (!this.keepAlive) {
            httpRequest.open(this.httpConnectionProvider);
        } else if (previouseResponse == null) {
            httpRequest.open(this.httpConnectionProvider).connectionKeepAlive(true);
        } else {
            httpRequest.keepAlive(previouseResponse, true);
        }
        return httpRequest.send();
    }

    protected void addDefaultHeaders(HttpRequest httpRequest) {
        for (Map.Entry entry : this.defaultHeaders.entries()) {
            String name = entry.getKey();
            if (httpRequest.headers.contains(name)) continue;
            httpRequest.headers.add(name, entry.getValue());
        }
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void close() {
        if (this.httpResponse != null) {
            this.httpResponse.close();
        }
    }

    public void clearCookies() {
        this.cookies.clear();
    }

    protected void readCookies(HttpResponse httpResponse) {
        Cookie[] newCookies;
        for (Cookie cookie : newCookies = httpResponse.cookies()) {
            this.cookies.add(cookie.getName(), cookie);
        }
    }

    protected void addCookies(HttpRequest httpRequest) {
        ArrayList<Cookie> cookiesList = new ArrayList<Cookie>();
        if (!this.cookies.isEmpty()) {
            for (Map.Entry<String, Cookie> entry : this.cookies) {
                cookiesList.add(entry.getValue());
            }
            httpRequest.cookies(cookiesList.toArray(new Cookie[0]));
        }
    }
}

