/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.Madvoc;
import jodd.madvoc.MadvocResponseWrapper;
import jodd.madvoc.WebApp;
import jodd.madvoc.component.MadvocController;
import jodd.servlet.DispatcherUtil;

public class MadvocServletFilter
implements Filter {
    private static Logger log;
    protected Madvoc madvoc;
    protected MadvocController madvocController;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.madvoc = Madvoc.get(servletContext);
        if (this.madvoc != null) {
            log = LoggerFactory.getLogger(this.getClass());
            this.madvocController = this.madvoc.webapp().madvocContainer().requestComponent(MadvocController.class);
            return;
        }
        WebApp webApp = WebApp.get(servletContext);
        if (webApp != null) {
            log = LoggerFactory.getLogger(this.getClass());
            this.madvocController = webApp.madvocContainer().requestComponent(MadvocController.class);
            return;
        }
        throw new ServletException("Neither Madvoc or WebApp found! Use MadvocContextListener to create Madvoc or WebApp#withServletContext() to make it available.");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean pathProcessed;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String actionPath = DispatcherUtil.getServletPath(request);
        try {
            MadvocResponseWrapper madvocResponse = new MadvocResponseWrapper(response);
            actionPath = this.madvocController.invoke(actionPath, request, (HttpServletResponse)madvocResponse);
        }
        catch (Exception ex) {
            log.error("Invoking action path failed: " + actionPath, (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        if (actionPath != null && !(pathProcessed = this.processUnhandledPath(actionPath, req, res))) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean processUnhandledPath(String actionPath, ServletRequest request, ServletResponse response) {
        return false;
    }
}

