/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.net.MalformedURLException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.result.AbstractTemplateViewActionResult;
import jodd.madvoc.result.Redirect;
import jodd.servlet.DispatcherUtil;

public class ServletDispatcherActionResult
extends AbstractTemplateViewActionResult {
    private static final Logger log = LoggerFactory.getLogger(ServletDispatcherActionResult.class);
    protected final String[] defaultViewExtensions = new String[]{".jspf", ".jsp"};
    protected final String defaultViewPageName = "index";

    @Override
    protected void renderView(ActionRequest actionRequest, String target) throws Exception {
        HttpServletRequest request = actionRequest.getHttpServletRequest();
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        RequestDispatcher dispatcher = request.getRequestDispatcher(target);
        if (dispatcher == null) {
            response.sendError(404, "Result not found: " + target);
            return;
        }
        if (DispatcherUtil.isPageIncluded(request, response)) {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    @Override
    protected String locateTarget(ActionRequest actionRequest, String path) {
        if (path.endsWith("/")) {
            path = path + "index";
        }
        for (String ext : this.defaultViewExtensions) {
            String target = path + ext;
            if (!this.targetExists(actionRequest, target)) continue;
            return target;
        }
        return null;
    }

    protected boolean targetExists(ActionRequest actionRequest, String target) {
        if (log.isDebugEnabled()) {
            log.debug("target check: " + target);
        }
        ServletContext servletContext = actionRequest.getHttpServletRequest().getServletContext();
        try {
            return servletContext.getResource(target) != null;
        }
        catch (MalformedURLException ignore) {
            return false;
        }
    }

    @Override
    protected Redirect resultOf(Object value) {
        if (value == null) {
            value = "";
        }
        return Redirect.to((String)value);
    }
}

