/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import jodd.mail.CommonEmail;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailAttachmentBuilder;
import jodd.mail.EmailUtil;
import jodd.mail.MailException;

public class ReceivedEmail
extends CommonEmail<ReceivedEmail> {
    public static final ReceivedEmail[] EMPTY_ARRAY = new ReceivedEmail[0];
    private File attachmentStorage;
    private Flags flags;
    private int messageNumber;
    private String messageId;
    private Date receivedDate;
    private final List<ReceivedEmail> attachedMessages = new ArrayList<ReceivedEmail>();

    public static ReceivedEmail create() {
        return new ReceivedEmail();
    }

    @Override
    public ReceivedEmail clone() {
        return ((ReceivedEmail)((ReceivedEmail)((ReceivedEmail)((ReceivedEmail)((ReceivedEmail)((ReceivedEmail)((ReceivedEmail)((ReceivedEmail)((ReceivedEmail)ReceivedEmail.create().flags(this.flags()).messageNumber(this.messageNumber()).messageId(this.messageId()).from(this.from())).replyTo(this.replyTo())).to(this.to())).cc(this.cc())).subject(this.subject(), this.subjectEncoding())).receivedDate(this.receivedDate()).sentDate(this.sentDate())).headers(this.headers())).message(this.messages())).storeAttachments(this.attachments())).attachedMessages(this.attachedMessages());
    }

    private ReceivedEmail() {
    }

    public ReceivedEmail(Message msg, boolean envelope, File attachmentStorage) {
        this.attachmentStorage = attachmentStorage;
        try {
            this.parseMessage(msg, envelope);
        }
        catch (Exception ex) {
            throw new MailException("Message parsing failed", ex);
        }
    }

    protected void parseMessage(Message msg, boolean envelope) throws MessagingException, IOException {
        Address[] addresses;
        this.flags(msg.getFlags());
        this.messageNumber(msg.getMessageNumber());
        if (msg instanceof MimeMessage) {
            this.messageId(((MimeMessage)msg).getMessageID());
        }
        if ((addresses = msg.getFrom()) != null && addresses.length > 0) {
            this.from(addresses[0]);
        }
        this.replyTo(msg.getReplyTo());
        this.to(msg.getRecipients(Message.RecipientType.TO));
        this.cc(msg.getRecipients(Message.RecipientType.CC));
        this.subject(msg.getSubject());
        this.receivedDate(msg.getReceivedDate());
        this.sentDate(msg.getSentDate());
        this.headers(msg.getAllHeaders());
        if (!envelope) {
            this.processPart((Part)msg);
        }
    }

    protected void processPart(Part part) throws MessagingException, IOException {
        Object content = part.getContent();
        if (content instanceof String) {
            this.addStringContent(part, (String)content);
        } else if (content instanceof Multipart) {
            this.processMultipart((Multipart)content);
        } else if (content instanceof InputStream) {
            this.addAttachment(part, (InputStream)content, this.attachmentStorage);
        } else if (content instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)content;
            this.attachedMessage(new ReceivedEmail((Message)mimeMessage, false, this.attachmentStorage));
        } else {
            this.addAttachment(part, part.getInputStream(), this.attachmentStorage);
        }
    }

    private void processMultipart(Multipart mp) throws MessagingException, IOException {
        int count = mp.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart innerPart = mp.getBodyPart(i);
            this.processPart((Part)innerPart);
        }
    }

    private void addStringContent(Part part, String content) throws MessagingException, UnsupportedEncodingException {
        String contentType = part.getContentType();
        String encoding = EmailUtil.extractEncoding(contentType, "US-ASCII");
        String disposition = part.getDisposition();
        if (disposition != null && disposition.equalsIgnoreCase("attachment")) {
            this.addAttachment(part, content.getBytes(encoding));
        } else {
            String mimeType = EmailUtil.extractMimeType(contentType);
            this.message(content, mimeType, encoding);
        }
    }

    protected static String parseContentId(Part part) throws MessagingException {
        if (part instanceof MimePart) {
            MimePart mp = (MimePart)part;
            return mp.getContentID();
        }
        return null;
    }

    protected static boolean parseInline(Part part) throws MessagingException {
        if (part instanceof MimePart) {
            String dispositionId = part.getDisposition();
            return dispositionId != null && dispositionId.equalsIgnoreCase("inline");
        }
        return false;
    }

    public Flags flags() {
        return this.flags;
    }

    public ReceivedEmail flags(Flags flags) {
        this.flags = flags;
        return this;
    }

    public boolean isAnswered() {
        return this.flags.contains(Flags.Flag.ANSWERED);
    }

    public boolean isDeleted() {
        return this.flags.contains(Flags.Flag.DELETED);
    }

    public boolean isDraft() {
        return this.flags.contains(Flags.Flag.DRAFT);
    }

    public boolean isFlagged() {
        return this.flags.contains(Flags.Flag.FLAGGED);
    }

    public boolean isRecent() {
        return this.flags.contains(Flags.Flag.RECENT);
    }

    public boolean isSeen() {
        return this.flags.contains(Flags.Flag.SEEN);
    }

    public int messageNumber() {
        return this.messageNumber;
    }

    public String messageId() {
        return this.messageId;
    }

    public ReceivedEmail messageNumber(int messageNumber) {
        this.messageNumber = messageNumber;
        return this;
    }

    public ReceivedEmail messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public ReceivedEmail receivedDate(Date date) {
        this.receivedDate = date;
        return this;
    }

    public Date receivedDate() {
        return this.receivedDate;
    }

    private ReceivedEmail addAttachment(Part part, InputStream content, File attachmentStorage) throws MessagingException, IOException {
        EmailAttachmentBuilder builder = ReceivedEmail.addAttachmentInfo(part);
        builder.content(content, part.getContentType());
        if (attachmentStorage != null) {
            String name = this.messageId + "-" + (this.attachments().size() + 1);
            return (ReceivedEmail)this.storeAttachment(builder.buildFileDataSource(name, attachmentStorage));
        }
        return (ReceivedEmail)this.storeAttachment(builder.buildByteArrayDataSource());
    }

    private ReceivedEmail addAttachment(Part part, byte[] content) throws MessagingException {
        EmailAttachmentBuilder builder = ReceivedEmail.addAttachmentInfo(part);
        builder.content(content, part.getContentType());
        EmailAttachment<ByteArrayDataSource> attachment = builder.buildByteArrayDataSource();
        attachment.setSize(content.length);
        return (ReceivedEmail)this.storeAttachment(attachment);
    }

    private static EmailAttachmentBuilder addAttachmentInfo(Part part) throws MessagingException {
        String fileName = EmailUtil.resolveFileName(part);
        String contentId = ReceivedEmail.parseContentId(part);
        boolean isInline = ReceivedEmail.parseInline(part);
        return new EmailAttachmentBuilder().name(fileName).contentId(contentId).inline(isInline);
    }

    public ReceivedEmail attachedMessages(List<ReceivedEmail> emails) {
        this.attachedMessages.addAll(emails);
        return this;
    }

    public ReceivedEmail attachedMessage(ReceivedEmail email) {
        this.attachedMessages.add(email);
        return this;
    }

    public List<ReceivedEmail> attachedMessages() {
        return this.attachedMessages;
    }
}

