/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.function.Consumer;
import jodd.io.findfile.ClassScanner;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.meta.PetiteBean;
import jodd.util.function.Consumers;

public class AutomagicPetiteConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicPetiteConfigurator.class);
    private static final byte[] PETITE_BEAN_ANNOTATION_BYTES = ClassScanner.bytecodeSignatureOfType(PetiteBean.class);
    private final PetiteContainer container;
    private final Consumers<ClassScanner> classScannerConsumers = new Consumers(new Consumer[0]);

    public AutomagicPetiteConfigurator(PetiteContainer petiteContainer) {
        this.container = petiteContainer;
    }

    public AutomagicPetiteConfigurator withScanner(Consumer<ClassScanner> scannerConsumer) {
        this.classScannerConsumers.add(scannerConsumer);
        return this;
    }

    public void configure() {
        long elapsed = System.currentTimeMillis();
        ClassScanner classScanner = new ClassScanner();
        classScanner.detectEntriesMode(true);
        classScanner.scanDefaultClasspath();
        this.classScannerConsumers.accept(classScanner);
        this.registerAsConsumer(classScanner);
        try {
            classScanner.start();
        }
        catch (Exception ex) {
            throw new PetiteException("Scan classpath error", ex);
        }
        elapsed = System.currentTimeMillis() - elapsed;
        log.info("Petite configured in " + elapsed + " ms. Total beans: " + this.container.beansCount());
    }

    public void registerAsConsumer(ClassScanner classScanner) {
        classScanner.registerEntryConsumer(classPathEntry -> {
            Class beanClass;
            if (!classPathEntry.isTypeSignatureInUse(PETITE_BEAN_ANNOTATION_BYTES)) {
                return;
            }
            try {
                beanClass = classPathEntry.loadClass();
            }
            catch (ClassNotFoundException cnfex) {
                throw new PetiteException("Unable to load class: " + cnfex, cnfex);
            }
            if (beanClass == null) {
                return;
            }
            PetiteBean petiteBean = beanClass.getAnnotation(PetiteBean.class);
            if (petiteBean == null) {
                return;
            }
            this.container.registerPetiteBean(beanClass, null, null, null, false, null);
        });
    }
}

