/*
 * Decompiled with CFR 0.152.
 */
package jodd.system;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

abstract class HostInfo {
    private final String HOST_NAME;
    private final String HOST_ADDRESS;

    public HostInfo() {
        String hostAddress;
        String hostName;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostName = localhost.getHostName();
            hostAddress = localhost.getHostAddress();
        }
        catch (UnknownHostException uhex) {
            hostName = "localhost";
            hostAddress = "127.0.0.1";
        }
        this.HOST_NAME = hostName;
        this.HOST_ADDRESS = hostAddress;
    }

    public final String getHostName() {
        return this.HOST_NAME;
    }

    public final String getHostAddress() {
        return this.HOST_ADDRESS;
    }

    protected String nosep(String in) {
        if (in.endsWith(File.separator)) {
            return in.substring(0, in.length() - 1);
        }
        return in;
    }

    public String toString() {
        return "\nHost name:    " + this.getHostName() + "\nHost address: " + this.getHostAddress();
    }
}

