/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import jodd.util.ArraysUtil;
import jodd.util.StringUtil;

public class Format {
    public static String alignLeftAndPad(String text, int size) {
        int textLength = text.length();
        if (textLength > size) {
            return text.substring(0, size);
        }
        StringBuilder sb = new StringBuilder(size);
        sb.append(text);
        while (textLength++ < size) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String alignRightAndPad(String text, int size) {
        int textLength = text.length();
        if (textLength > size) {
            return text.substring(textLength - size, textLength);
        }
        StringBuilder sb = new StringBuilder(size);
        while (textLength++ < size) {
            sb.append(' ');
        }
        sb.append(text);
        return sb.toString();
    }

    public static String humanReadableByteCount(long bytes, boolean useSi) {
        int unit;
        int n = unit = useSi ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (useSi ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (useSi ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String toPrettyString(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType.isPrimitive()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                if (componentType == Integer.TYPE) {
                    sb.append(ArraysUtil.toString((int[])value));
                } else if (componentType == Long.TYPE) {
                    sb.append(ArraysUtil.toString((long[])value));
                } else if (componentType == Double.TYPE) {
                    sb.append(ArraysUtil.toString((double[])value));
                } else if (componentType == Float.TYPE) {
                    sb.append(ArraysUtil.toString((float[])value));
                } else if (componentType == Boolean.TYPE) {
                    sb.append(ArraysUtil.toString((boolean[])value));
                } else if (componentType == Short.TYPE) {
                    sb.append(ArraysUtil.toString((short[])value));
                } else if (componentType == Byte.TYPE) {
                    sb.append(ArraysUtil.toString((byte[])value));
                } else {
                    throw new IllegalArgumentException();
                }
                sb.append(']');
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Format.toPrettyString(array[i]));
            }
            sb.append(']');
            return sb.toString();
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int i = 0;
            for (Object o : iterable) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Format.toPrettyString(o));
                ++i;
            }
            sb.append('}');
            return sb.toString();
        }
        return value.toString();
    }

    public static String fromCamelCase(String input, char separator) {
        int length = input.length();
        StringBuilder result = new StringBuilder(length * 2);
        int resultLength = 0;
        boolean prevTranslated = false;
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (i <= 0 && c == separator) continue;
            if (Character.isUpperCase(c)) {
                if (!prevTranslated && resultLength > 0 && result.charAt(resultLength - 1) != separator) {
                    result.append(separator);
                    ++resultLength;
                }
                c = Character.toLowerCase(c);
                prevTranslated = true;
            } else {
                prevTranslated = false;
            }
            result.append(c);
            ++resultLength;
        }
        return resultLength > 0 ? result.toString() : input;
    }

    public static String toCamelCase(String input, boolean firstCharUppercase, char separator) {
        int length = input.length();
        StringBuilder sb = new StringBuilder(length);
        boolean upperCase = firstCharUppercase;
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            if (ch == separator) {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(ch));
                upperCase = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String formatParagraph(String src, int len, boolean breakOnWhitespace) {
        StringBuilder str = new StringBuilder();
        int total = src.length();
        int from = 0;
        while (from < total) {
            int ndx;
            int to = from + len;
            if (to >= total) {
                to = total;
            } else if (breakOnWhitespace && (ndx = StringUtil.lastIndexOfWhitespace(src, to - 1, from)) != -1) {
                to = ndx + 1;
            }
            int cutFrom = StringUtil.indexOfNonWhitespace(src, from, to);
            if (cutFrom != -1) {
                int cutTo = StringUtil.lastIndexOfNonWhitespace(src, to - 1, from) + 1;
                str.append(src, cutFrom, cutTo);
            }
            str.append('\n');
            from = to;
        }
        return str.toString();
    }

    public static String convertTabsToSpaces(String line, int tabWidth) {
        int tab_index;
        int last_tab_index = 0;
        int added_chars = 0;
        if (tabWidth == 0) {
            return StringUtil.remove(line, '\t');
        }
        StringBuilder result = new StringBuilder();
        while ((tab_index = line.indexOf(9, last_tab_index)) != -1) {
            int tab_size = tabWidth - (tab_index + added_chars) % tabWidth;
            if (tab_size == 0) {
                tab_size = tabWidth;
            }
            added_chars += tab_size - 1;
            result.append(line, last_tab_index, tab_index);
            result.append(StringUtil.repeat(' ', tab_size));
            last_tab_index = tab_index + 1;
        }
        if (last_tab_index == 0) {
            return line;
        }
        result.append(line.substring(last_tab_index));
        return result.toString();
    }

    public static String escapeJava(String string) {
        int strLen = string.length();
        StringBuilder sb = new StringBuilder(strLen);
        block9: for (int i = 0; i < strLen; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        String hex = Integer.toHexString(c);
                        sb.append("\\u");
                        for (int k = hex.length(); k < 4; ++k) {
                            sb.append('0');
                        }
                        sb.append(hex);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String unescapeJava(String str) {
        char[] chars = str.toCharArray();
        StringBuilder sb = new StringBuilder(str.length());
        block10: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c != '\\') {
                sb.append(c);
                continue;
            }
            c = chars[++i];
            switch (c) {
                case 'b': {
                    sb.append('\b');
                    continue block10;
                }
                case 't': {
                    sb.append('\t');
                    continue block10;
                }
                case 'n': {
                    sb.append('\n');
                    continue block10;
                }
                case 'f': {
                    sb.append('\f');
                    continue block10;
                }
                case 'r': {
                    sb.append('\r');
                    continue block10;
                }
                case '\"': {
                    sb.append('\"');
                    continue block10;
                }
                case '\\': {
                    sb.append('\\');
                    continue block10;
                }
                case 'u': {
                    char hex = (char)Integer.parseInt(new String(chars, i + 1, 4), 16);
                    sb.append(hex);
                    i += 4;
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Invalid escaping character: " + c);
                }
            }
        }
        return sb.toString();
    }
}

