/*
 * Decompiled with CFR 0.152.
 */
package jodd.crypt;

import jodd.util.StringUtil;

public class MurmurHash3 {
    public static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long getLongLittleEndian(byte[] buf, int offset) {
        return (long)buf[offset + 7] << 56 | ((long)buf[offset + 6] & 0xFFL) << 48 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 2] & 0xFFL) << 16 | ((long)buf[offset + 1] & 0xFFL) << 8 | (long)buf[offset] & 0xFFL;
    }

    public static HashValue murmurhash3_x64_128(String str, int seed) {
        byte[] bytes = StringUtil.getBytes(str);
        return MurmurHash3.murmurhash3_x64_128(bytes, 0, bytes.length, seed);
    }

    public static HashValue murmurhash3_x64_128(byte[] key, int offset, int len, int seed) {
        long h1 = (long)seed & 0xFFFFFFFFL;
        long h2 = (long)seed & 0xFFFFFFFFL;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int roundedEnd = offset + (len & 0xFFFFFFF0);
        for (int i = offset; i < roundedEnd; i += 16) {
            long k1 = MurmurHash3.getLongLittleEndian(key, i);
            long k2 = MurmurHash3.getLongLittleEndian(key, i + 8);
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 = ((long)key[roundedEnd + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 |= ((long)key[roundedEnd + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 |= ((long)key[roundedEnd + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 |= ((long)key[roundedEnd + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 |= ((long)key[roundedEnd + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 |= ((long)key[roundedEnd + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 |= (long)key[roundedEnd + 8] & 0xFFL;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 = (long)key[roundedEnd + 7] << 56;
            }
            case 7: {
                k1 |= ((long)key[roundedEnd + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 |= ((long)key[roundedEnd + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 |= ((long)key[roundedEnd + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 |= ((long)key[roundedEnd + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 |= ((long)key[roundedEnd + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 |= ((long)key[roundedEnd + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 |= (long)key[roundedEnd] & 0xFFL;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)len;
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = MurmurHash3.fmix64(h1);
        h2 = MurmurHash3.fmix64(h2);
        h1 += h2;
        return new HashValue(h1, h2 += h1);
    }

    public static final class HashValue {
        public final long val1;
        public final long val2;

        public HashValue(long val1, long val2) {
            this.val1 = val1;
            this.val2 = val2;
        }

        public String toString() {
            return Long.toHexString(this.val1) + Long.toHexString(this.val2);
        }
    }
}

