/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx;

import java.util.Objects;
import jodd.jtx.JtxIsolationLevel;
import jodd.jtx.JtxPropagationBehavior;

public class JtxTransactionMode {
    protected final JtxPropagationBehavior propagationBehavior;
    private final JtxIsolationLevel isolationLevel;
    public static final boolean READ_ONLY = true;
    public static final boolean READ_WRITE = false;
    private final boolean readOnlyMode;
    public static final int DEFAULT_TIMEOUT = -1;
    private final int timeout;
    public static final JtxTransactionMode PROPAGATION_SUPPORTS_READ_ONLY = new JtxTransactionMode(JtxPropagationBehavior.PROPAGATION_SUPPORTS, JtxIsolationLevel.ISOLATION_DEFAULT, true, -1);

    public JtxTransactionMode(JtxPropagationBehavior propagationBehavior, JtxIsolationLevel isolationLevel, boolean readOnly, int timeout) {
        this.propagationBehavior = propagationBehavior;
        this.isolationLevel = isolationLevel;
        this.readOnlyMode = readOnly;
        this.timeout = timeout;
    }

    public JtxTransactionMode(JtxPropagationBehavior propagationBehavior, boolean readOnly) {
        this.propagationBehavior = propagationBehavior;
        this.isolationLevel = JtxIsolationLevel.ISOLATION_DEFAULT;
        this.readOnlyMode = readOnly;
        this.timeout = -1;
    }

    public JtxPropagationBehavior getPropagationBehavior() {
        return this.propagationBehavior;
    }

    public JtxIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public int getTransactionTimeout() {
        return this.timeout;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JtxTransactionMode mode = (JtxTransactionMode)object;
        return mode.getPropagationBehavior() == this.propagationBehavior && mode.getIsolationLevel() == this.isolationLevel && mode.isReadOnly() == this.readOnlyMode && mode.getTransactionTimeout() == this.timeout;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.propagationBehavior, this.readOnlyMode, this.isolationLevel, this.timeout});
    }

    public String toString() {
        return "jtx{" + (Object)((Object)this.propagationBehavior) + ',' + (this.readOnlyMode ? "readonly" : "readwrite") + ',' + this.isolationLevel.toString() + ',' + this.timeout + '}';
    }
}

