/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.WiringMode;
import jodd.petite.meta.PetiteBean;
import jodd.petite.scope.Scope;
import jodd.util.StringUtil;

public class AnnotationResolver {
    public WiringMode resolveBeanWiringMode(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        return petiteBean != null ? petiteBean.wiring() : WiringMode.DEFAULT;
    }

    public Class<? extends Scope> resolveBeanScopeType(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        return petiteBean != null ? petiteBean.scope() : null;
    }

    public String resolveBeanName(Class type, boolean useLongTypeName) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        String name = null;
        if (petiteBean != null) {
            name = petiteBean.value().trim();
        }
        if (name == null || name.length() == 0) {
            name = useLongTypeName ? type.getName() : StringUtil.uncapitalize(type.getSimpleName());
        }
        return name;
    }

    public boolean beanHasAnnotationName(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        if (petiteBean == null) {
            return false;
        }
        String name = petiteBean.value().trim();
        return !name.isEmpty();
    }
}

