/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.decora.DecoraManager;
import jodd.decora.DecoraRequestWrapper;
import jodd.decora.DecoraResponseWrapper;
import jodd.decora.parser.DecoraParser;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.servlet.DispatcherUtil;
import jodd.servlet.wrapper.BufferResponseWrapper;
import jodd.servlet.wrapper.LastModifiedData;
import jodd.util.ClassLoaderUtil;

public class DecoraServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DecoraServletFilter.class);
    public static final String PARAM_DECORA_MANAGER = "decora.manager";
    public static final String PARAM_DECORA_PARSER = "decora.parser";
    protected DecoraManager decoraManager;
    protected DecoraParser decoraParser;

    protected DecoraManager createDecoraManager() {
        return new DecoraManager();
    }

    protected DecoraParser createDecoraParser() {
        return new DecoraParser();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String decoraManagerClass = filterConfig.getInitParameter(PARAM_DECORA_MANAGER);
        if (decoraManagerClass != null) {
            try {
                Class decoraManagerType = ClassLoaderUtil.loadClass((String)decoraManagerClass);
                this.decoraManager = (DecoraManager)decoraManagerType.newInstance();
            }
            catch (Exception ex) {
                log.error("Unable to load Decora manager class: " + decoraManagerClass, (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
        } else {
            this.decoraManager = this.createDecoraManager();
        }
        String decoraParserClass = filterConfig.getInitParameter(PARAM_DECORA_PARSER);
        if (decoraParserClass != null) {
            try {
                Class decoraParserType = ClassLoaderUtil.loadClass((String)decoraParserClass);
                this.decoraParser = (DecoraParser)decoraParserType.newInstance();
            }
            catch (Exception ex) {
                log.error("Unable to load Decora parser class: " + decoraParserClass, (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
        } else {
            this.decoraParser = this.createDecoraParser();
        }
    }

    public void destroy() {
    }

    protected HttpServletRequest wrapRequest(HttpServletRequest request) {
        return new DecoraRequestWrapper(request);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.decoraManager.decorateRequest(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest decoraRequest = this.wrapRequest(request);
        LastModifiedData lastModifiedData = new LastModifiedData();
        DecoraResponseWrapper pageWrapper = new DecoraResponseWrapper(request, response, lastModifiedData, this.decoraManager);
        filterChain.doFilter((ServletRequest)decoraRequest, (ServletResponse)pageWrapper);
        if (!pageWrapper.isBufferingEnabled()) {
            return;
        }
        char[] pageContent = pageWrapper.getBufferContentAsChars();
        if (pageContent == null || pageContent.length == 0) {
            return;
        }
        boolean decorated = false;
        String actionPath = DispatcherUtil.getServletPath((HttpServletRequest)request);
        String decoratorPath = this.decoraManager.resolveDecorator(request, actionPath);
        if (decoratorPath != null) {
            BufferResponseWrapper decoratorWrapper = new BufferResponseWrapper(response, lastModifiedData);
            DispatcherUtil.forward((ServletRequest)decoraRequest, (ServletResponse)decoratorWrapper, (String)decoratorPath);
            char[] decoraContent = decoratorWrapper.getBufferedChars();
            PrintWriter writer = servletResponse.getWriter();
            this.decoraParser.decorate(writer, pageContent, decoraContent);
            ((Writer)writer).flush();
            decorated = true;
        }
        pageWrapper.commitResponse();
        if (!decorated) {
            if (pageWrapper.isBufferStreamBased()) {
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(pageWrapper.getBufferedBytes());
                outputStream.flush();
            } else {
                PrintWriter writer = response.getWriter();
                writer.append(CharBuffer.wrap(pageWrapper.getBufferedChars()));
                writer.flush();
            }
        }
    }
}

