/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.core;

import jodd.io.findfile.ClassFinder;
import jodd.joy.core.DefaultAppCore;
import jodd.props.Props;
import jodd.typeconverter.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppScanner {
    private static final Logger log = LoggerFactory.getLogger(AppScanner.class);
    private static final String PROPS_PREFIX = "app-scan";
    protected final DefaultAppCore appCore;
    protected String[] includedEntries;
    protected String[] includedJars;
    protected boolean ignoreExceptions;

    public AppScanner(DefaultAppCore appCore) {
        this.appCore = appCore;
    }

    public void init() {
        Props appProps = this.appCore.getAppProps();
        String value = appProps.getValue("app-scan.includedEntries");
        this.includedEntries = value == null ? new String[]{this.appCore.getClass().getPackage().getName() + ".*", "jodd.*"} : Convert.toStringArray((Object)value);
        if (log.isDebugEnabled()) {
            log.debug("Scan entries: " + Convert.toString((Object)this.includedEntries));
        }
        this.includedJars = (value = appProps.getValue("app-scan.includedJars")) == null ? null : Convert.toStringArray((Object)value);
        if (log.isDebugEnabled()) {
            log.debug("Scan jars: " + Convert.toString((Object)this.includedJars));
        }
        this.ignoreExceptions = (value = appProps.getValue("app-scan.ignoreExceptions")) == null ? false : Convert.toBooleanValue((Object)value);
        if (log.isDebugEnabled()) {
            log.debug("Scan ignore exception: " + this.ignoreExceptions);
        }
    }

    public void configure(ClassFinder classFinder) {
        if (this.includedEntries != null) {
            classFinder.setIncludedEntries(this.includedEntries);
        }
        if (this.includedJars != null) {
            classFinder.setIncludedJars(this.includedJars);
        }
        classFinder.setIgnoreException(this.ignoreExceptions);
    }
}

