/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.db;

import java.util.HashMap;
import java.util.Map;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.DbOomQuery;
import jodd.joy.db.Entity;
import jodd.mutable.MutableLong;
import jodd.petite.meta.PetiteBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PetiteBean
public class DbIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(DbIdGenerator.class);
    protected Map<Class<? extends Entity>, MutableLong> entityIdsMap = new HashMap<Class<? extends Entity>, MutableLong>();

    public synchronized void reset() {
        this.entityIdsMap.clear();
    }

    public long nextId(Entity entity) {
        Class<?> entityType = entity.getClass();
        return this.nextId(entityType);
    }

    public synchronized long nextId(Class<? extends Entity> entityType) {
        MutableLong lastId = this.entityIdsMap.get(entityType);
        if (lastId == null) {
            DbOomManager dbOomManager = DbOomManager.getInstance();
            DbEntityDescriptor ded = dbOomManager.lookupType(entityType);
            String tableName = ded.getTableName();
            String idColumn = ded.getIdColumnName();
            DbOomQuery dbOomQuery = DbOomQuery.query((String)("select max(" + idColumn + ") from " + tableName));
            long lastLong = dbOomQuery.executeCountAndClose();
            if (log.isDebugEnabled()) {
                log.debug("Last id for " + entityType.getName() + " is " + lastLong);
            }
            lastId = new MutableLong(lastLong);
        }
        ++lastId.value;
        return lastId.value;
    }
}

