/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.page;

import java.util.List;
import java.util.Map;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.sqlgen.DbSqlBuilder;
import jodd.joy.page.PageData;
import jodd.joy.page.PageRequest;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbPager {
    public <T> PageData<T> page(PageRequest pageRequest, String sql, Map params, String[] sortColumns, Class[] target) {
        PageData<T> pageData = this.page(sql, pageRequest.getPage(), pageRequest.getSize(), params, pageRequest.getSort(), sortColumns, target);
        if (pageData.getItems().isEmpty() && pageData.currentPage != 0 && pageData.currentPage != pageRequest.getPage()) {
            int newPage = pageData.getCurrentPage();
            pageData = this.page(sql, newPage, pageRequest.getSize(), params, pageRequest.getSort(), sortColumns, target);
        }
        return pageData;
    }

    protected <T> PageData<T> page(String sql, int page, int pageSize, Map params, int sort, String[] sortColumns, Class[] target) {
        if (sort != 0) {
            boolean ascending;
            boolean bl = ascending = sort > 0;
            if (!ascending) {
                sort = -sort;
            }
            int index = sort - 1;
            sql = this.buildOrderSql(sql, sortColumns[index], ascending);
        }
        int from = (page - 1) * pageSize;
        String pageSql = this.buildPageSql(sql, from, pageSize);
        DbSqlBuilder dbsql = DbSqlBuilder.sql((String)pageSql);
        DbOomQuery query = DbOomQuery.query((DbSqlGenerator)dbsql);
        query.setMaxRows(pageSize);
        query.setFetchSize(pageSize);
        query.setMap(params);
        List list = query.listAndClose(pageSize, target);
        String countSql = this.buildCountSql(sql);
        dbsql = DbSqlBuilder.sql((String)countSql);
        long count = DbOomQuery.query((DbSqlGenerator)dbsql).executeCountAndClose();
        return new PageData(page, (int)count, pageSize, list);
    }

    protected abstract String buildOrderSql(String var1, String var2, boolean var3);

    protected abstract String buildPageSql(String var1, int var2, int var3);

    protected abstract String buildCountSql(String var1);

    protected String removeSelect(String sql) {
        int ndx = StringUtil.indexOfIgnoreCase((String)sql, (String)"select");
        if (ndx != -1) {
            sql = sql.substring(ndx + 6);
        }
        return sql;
    }

    protected String removeToFrom(String sql) {
        int ndx = StringUtil.indexOfIgnoreCase((String)sql, (String)"from");
        if (ndx != -1) {
            sql = sql.substring(ndx);
        }
        return sql;
    }

    protected String removeLastOrderBy(String sql) {
        int ndx2;
        int ndx = StringUtil.lastIndexOfIgnoreCase((String)sql, (String)"order by");
        if (ndx != -1 && ndx > (ndx2 = sql.lastIndexOf(sql, 41))) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }
}

