/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.core;

import jodd.io.findfile.ClassFinder;
import jodd.joy.core.DefaultAppCore;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.typeconverter.Convert;

public class AppScanner {
    private static final Logger log = LoggerFactory.getLogger(AppScanner.class);
    protected final DefaultAppCore appCore;
    protected String[] includedEntries;
    protected String[] includedJars;
    protected boolean ignoreExceptions;

    public AppScanner(DefaultAppCore appCore) {
        this.appCore = appCore;
    }

    public String[] getIncludedEntries() {
        return this.includedEntries;
    }

    public void setIncludedEntries(String ... includedEntries) {
        this.includedEntries = includedEntries;
    }

    public String[] getIncludedJars() {
        return this.includedJars;
    }

    public void setIncludedJars(String ... includedJars) {
        this.includedJars = includedJars;
    }

    public boolean isIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }

    public void configure(ClassFinder classFinder) {
        if (this.includedEntries == null) {
            this.includedEntries = new String[]{this.appCore.getClass().getPackage().getName() + ".*", "jodd.*"};
        }
        if (log.isDebugEnabled()) {
            log.debug("Scan entries: " + Convert.toString((Object)this.includedEntries));
            log.debug("Scan jars: " + Convert.toString((Object)this.includedJars));
            log.debug("Scan ignore exception: " + this.ignoreExceptions);
        }
        if (this.includedEntries != null) {
            classFinder.setIncludedEntries(this.includedEntries);
        }
        if (this.includedJars != null) {
            classFinder.setIncludedJars(this.includedJars);
        }
        classFinder.setIgnoreException(this.ignoreExceptions);
    }
}

