/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import jodd.bean.BeanUtil;
import jodd.joy.core.DefaultAppCore;
import jodd.joy.db.AppDao;
import jodd.jtx.JtxTransaction;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import jodd.madvoc.Madvoc;
import jodd.madvoc.WebApplication;
import jodd.madvoc.component.MadvocConfig;
import jodd.petite.PetiteContainer;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

public abstract class WebRunner {
    protected Madvoc madvoc;
    protected WebApplication app;
    protected DefaultAppCore appCore;
    protected AppDao appDao;
    protected PetiteContainer petite;
    protected static JtxTransactionManager jtxManager;

    public void runWebApp(Class<? extends WebApplication> webAppClass) {
        this.madvoc = new Madvoc();
        this.madvoc.setWebAppClass(webAppClass);
        this.madvoc.startNewWebApplication(null);
        this.app = this.madvoc.getWebApplication();
        this.appCore = (DefaultAppCore)BeanUtil.getDeclaredProperty((Object)this.app, (String)"appCore");
        WebRunner.setJtxManager(this.appCore.getJtxManager());
        this.appDao = (AppDao)((Object)this.appCore.getPetite().getBean(AppDao.class));
        this.petite = this.appCore.getPetite();
        JtxTransaction tx = WebRunner.startRwTx();
        try {
            System.out.println(StringUtil.repeat((char)'-', (int)55) + " start");
            System.out.println("\n\n");
            this.run();
            System.out.println("\n\n");
            System.out.println(StringUtil.repeat((char)'-', (int)55) + " end");
            tx.commit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            tx.rollback();
        }
        try {
            ReflectUtil.invokeDeclared((Object)this.app, (String)"destroy", (Class[])new Class[]{MadvocConfig.class}, (Object[])new Object[]{null});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public abstract void run();

    public static void setJtxManager(JtxTransactionManager jm) {
        jtxManager = jm;
    }

    public static JtxTransaction startRwTx() {
        return jtxManager.requestTransaction(new JtxTransactionMode().propagationRequired().readOnly(false));
    }
}

