/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import jodd.io.findfile.ClassScanner;
import jodd.joy.JoyBase;
import jodd.typeconverter.Converter;

public class JoyScanner
extends JoyBase
implements Consumer<ClassScanner> {
    private List<String> includedEntries = new ArrayList<String>();
    private List<String> includedJars = new ArrayList<String>();
    private boolean ignoreExceptions;

    public JoyScanner setIncludedEntries(String ... includedEntries) {
        Collections.addAll(this.includedEntries, includedEntries);
        return this;
    }

    public JoyScanner setIncludedJars(String ... includedJars) {
        Collections.addAll(this.includedJars, includedJars);
        return this;
    }

    public JoyScanner setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
        return this;
    }

    @Override
    public void start() {
        this.initLogger();
        this.log.info("SCANNER start ----------");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Scan entries: " + Converter.get().toString(this.includedEntries));
            this.log.debug("Scan jars: " + Converter.get().toString(this.includedJars));
            this.log.debug("Scan ignore exception: " + this.ignoreExceptions);
        }
    }

    @Override
    public void accept(ClassScanner classScanner) {
        if (this.includedEntries.isEmpty() && this.includedJars.isEmpty()) {
            classScanner.excludeAllEntries(false);
            classScanner.excludeEntries(new String[]{"ch.qos.logback.*"});
        } else {
            classScanner.excludeAllEntries(true);
            this.includedEntries.add("jodd.*");
        }
        classScanner.includeEntries(this.includedEntries.toArray(new String[this.includedEntries.size()])).includeJars(this.includedJars.toArray(new String[this.includedJars.size()])).ignoreException(this.ignoreExceptions);
    }

    @Override
    public void stop() {
        this.includedEntries.clear();
        this.includedJars.clear();
    }
}

