/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import jodd.joy.JoyBase;
import jodd.joy.JoyScanner;
import jodd.joy.madvoc.interceptor.DefaultInterceptorStack;
import jodd.madvoc.AutomagicMadvocConfigurator;
import jodd.madvoc.WebApp;
import jodd.madvoc.petite.PetiteWebApp;
import jodd.madvoc.proxetta.ProxettaAwareActionsManager;
import jodd.madvoc.proxetta.ProxettaProvider;
import jodd.petite.PetiteContainer;
import jodd.props.Props;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.util.Consumers;

public class JoyMadvoc
extends JoyBase {
    private final Supplier<ProxyProxetta> proxettaSupplier;
    private final Supplier<PetiteContainer> petiteSupplier;
    private final Supplier<JoyScanner> scannerSupplier;
    private final Consumers<WebApp> webAppConsumers;
    private final Supplier<Props> propsSupplier;
    private ServletContext servletContext;
    private PetiteWebApp webApp;

    public JoyMadvoc(Supplier<PetiteContainer> petiteSupplier, Supplier<ProxyProxetta> proxettaSupplier, Supplier<Props> propsSupplier, Supplier<JoyScanner> scannerSupplier) {
        this.proxettaSupplier = proxettaSupplier;
        this.petiteSupplier = petiteSupplier;
        this.scannerSupplier = scannerSupplier;
        this.propsSupplier = propsSupplier;
        this.webAppConsumers = Consumers.empty();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void add(Consumer<WebApp> webAppConsumer) {
        this.webAppConsumers.add(webAppConsumer);
    }

    @Override
    public void start() {
        this.initLogger();
        this.log.info("MADVOC start  ----------");
        this.webApp = new PetiteWebApp();
        this.webApp.configure(madvocConfig -> madvocConfig.getActionConfig().setInterceptors(new Class[]{DefaultInterceptorStack.class}));
        this.webApp.withPetiteContainer(this.petiteSupplier);
        if (this.servletContext != null) {
            this.webApp.bindServletContext(this.servletContext);
        }
        this.webApp.withParams(this.propsSupplier.get());
        this.webApp.registerComponent((Object)new ProxettaProvider(this.proxettaSupplier.get()));
        this.webApp.registerComponent(ProxettaAwareActionsManager.class);
        this.webApp.registerComponent(AutomagicMadvocConfigurator.class, amc -> amc.withScanner((Consumer)this.scannerSupplier.get()));
        this.webAppConsumers.accept((Object)this.webApp);
        this.webApp.start();
    }

    @Override
    public void stop() {
        if (this.log != null) {
            this.log.info("MADVOC stop  ----------");
        }
        if (this.webApp != null) {
            this.webApp.shutdown();
        }
    }
}

