/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import jodd.joy.auth.PasswordEncoder;
import jodd.joy.auth.UserAuth;
import jodd.petite.meta.PetiteInject;

public abstract class UserAuthManagerBean<U extends UserAuth> {
    @PetiteInject
    protected PasswordEncoder passwordEncoder;

    public abstract U findUserAuthByUsername(String var1);

    public abstract U findUserAuthById(long var1);

    public abstract void login(U var1);

    public final U findUser(String username, String rawPassword) {
        U userAuth = this.findUserAuthByUsername(username);
        if (userAuth == null) {
            return null;
        }
        if (!this.passwordEncoder.isPasswordValid(userAuth.getHashedPassword(), rawPassword)) {
            return null;
        }
        return userAuth;
    }

    public final U findUser(long userId, String hashedPassword) {
        U userAuth = this.findUserAuthById(userId);
        if (userAuth == null) {
            return null;
        }
        if (hashedPassword == null) {
            return null;
        }
        if (!hashedPassword.equals(userAuth.getHashedPassword())) {
            return null;
        }
        return userAuth;
    }
}

