/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jodd.joy.auth.AuthUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.servlet.CsrfShield;
import jodd.util.StringUtil;

public abstract class AuthenticationInterceptor<U>
implements ActionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    protected boolean useCookie = true;
    protected int cookieMaxAge = 1209600;
    protected boolean recreateCookieOnLogin;

    public Object intercept(ActionRequest actionRequest) throws Exception {
        Object newUserSession;
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        HttpSession session = servletRequest.getSession();
        String actionPath = actionRequest.getActionPath();
        if (this.isLogoutAction(actionPath)) {
            log.debug("logout user");
            this.closeAuthSession(servletRequest, servletResponse);
            return this.resultLogoutSuccess();
        }
        Object userSession = AuthUtil.getUserSession(session);
        if (userSession != null) {
            if (this.isLoginAction(actionPath)) {
                return this.resultLoginSuccess(null);
            }
            return actionRequest.invoke();
        }
        String[] cookieData = null;
        if (this.useCookie) {
            try {
                cookieData = AuthUtil.readAuthCookie(servletRequest);
            }
            catch (Exception ex) {
                log.warn("invalid cookie", (Throwable)ex);
            }
        }
        if (cookieData != null) {
            userSession = this.loginViaCookie(cookieData);
            if (userSession != null) {
                log.debug("login with cookie");
                this.startAuthSession(servletRequest, servletResponse, userSession, false);
                if (this.isLoginAction(actionPath)) {
                    return this.resultLoginSuccess(null);
                }
                return actionRequest.invoke();
            }
            this.closeAuthSession(servletRequest, servletResponse);
        }
        if (this.isRegisterAction(actionPath) && (newUserSession = AuthUtil.getNewUserSession(servletRequest)) != null) {
            log.debug("new user session created");
            this.startAuthSession(servletRequest, servletResponse, newUserSession, true);
            return this.resultRegistrationSuccess();
        }
        if (!this.isLoginAction(actionPath)) {
            return actionRequest.invoke();
        }
        String token = servletRequest.getParameter("j_token");
        if (!CsrfShield.checkCsrfToken((HttpSession)session, (String)token)) {
            log.warn("csrf token validation failed");
            return this.resultLoginFailed(2);
        }
        userSession = this.loginViaRequest(servletRequest);
        if (userSession == null) {
            log.warn("login failed");
            return this.resultLoginFailed(1);
        }
        this.startAuthSession(servletRequest, servletResponse, userSession, true);
        log.info("login ok");
        String path = servletRequest.getParameter("j_path");
        return this.resultLoginSuccess(path);
    }

    protected void startAuthSession(HttpServletRequest servletRequest, HttpServletResponse servletResponse, U userSession, boolean isNew) {
        String[] cookieData;
        AuthUtil.startUserSession(servletRequest, userSession);
        if (!this.useCookie) {
            return;
        }
        if ((isNew || this.recreateCookieOnLogin) && (cookieData = this.createCookieData(userSession)) != null) {
            AuthUtil.storeAuthCookie(servletResponse, this.cookieMaxAge, cookieData[0], cookieData[1]);
        }
    }

    protected void closeAuthSession(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        AuthUtil.closeUserSession(servletRequest);
        AuthUtil.removeAuthCookie(servletRequest, servletResponse);
    }

    protected boolean isLoginAction(String actionPath) {
        return actionPath.equals("/j_login");
    }

    protected boolean isLogoutAction(String actionPath) {
        return actionPath.equals("/j_logout");
    }

    protected boolean isRegisterAction(String actionPath) {
        return actionPath.equals("/j_register");
    }

    protected Object resultLoginSuccess(String path) {
        if (StringUtil.isEmpty((CharSequence)path)) {
            path = "<index>";
        }
        return "redirect:" + path;
    }

    protected Object resultLogoutSuccess() {
        return "redirect:<index>";
    }

    protected Object resultRegistrationSuccess() {
        return "redirect:<index>";
    }

    protected Object resultLoginFailed(int reason) {
        return "redirect:<login>?err=" + reason;
    }

    protected abstract U loginViaCookie(String[] var1);

    protected U loginViaRequest(HttpServletRequest servletRequest) {
        String username = servletRequest.getParameter("j_username");
        String password = servletRequest.getParameter("j_password");
        log.info("login " + username);
        return this.loginUsernamePassword(username, password);
    }

    protected abstract U loginUsernamePassword(String var1, String var2);

    protected abstract String[] createCookieData(U var1);
}

