/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jodd.joy.auth.AuthUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.servlet.DispatcherUtil;
import jodd.util.net.URLCoder;

public abstract class AuthorizationInterceptor
implements ActionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationInterceptor.class);

    public Object intercept(ActionRequest actionRequest) throws Exception {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        HttpSession session = servletRequest.getSession();
        Object userSession = AuthUtil.getUserSession(session);
        if (log.isDebugEnabled()) {
            log.debug("authorize user: " + userSession);
        }
        if (!this.authorize(actionRequest, userSession)) {
            if (log.isInfoEnabled()) {
                log.info("access denied for: " + userSession);
            }
            servletResponse.setStatus(403);
            if (userSession != null) {
                return this.resultAccessDenied();
            }
            return this.resultLogin(DispatcherUtil.getUrl((HttpServletRequest)servletRequest));
        }
        if (log.isInfoEnabled()) {
            log.info("access granted for: " + userSession);
        }
        return actionRequest.invoke();
    }

    protected Object resultAccessDenied() {
        return "redirect:<accessDenied>";
    }

    protected Object resultLogin(String targetUrl) {
        targetUrl = targetUrl == null ? "" : '?' + URLCoder.encodeQueryParam((String)"j_path") + '=' + URLCoder.encodeQueryParam((String)targetUrl);
        return "redirect:<login>" + targetUrl;
    }

    protected abstract boolean authorize(ActionRequest var1, Object var2);
}

