/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.joy.auth.UserAuth;
import jodd.joy.auth.UserSession;
import jodd.json.JsonObject;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.scope.Request;
import jodd.madvoc.result.JsonResult;
import jodd.net.HttpStatus;
import jodd.petite.meta.PetiteInject;
import jodd.servlet.ServletUtil;
import jodd.util.StringUtil;

public abstract class AuthAction<T> {
    private static final Logger log = LoggerFactory.getLogger(AuthAction.class);
    public static final String J_LOGIN_PATH = "/j_login";
    public static final String J_LOGOUT_PATH = "/j_logout";
    public static final String PARAM_USERNAME = "j_username";
    public static final String PARAM_PASSWORD = "j_password";
    public static final String ALIAS_INDEX = "<index>";
    public static final String ALIAS_LOGIN = "<login>";
    @In
    @Request
    protected HttpServletRequest servletRequest;
    @In
    @Request
    protected HttpServletResponse servletResponse;
    @PetiteInject
    protected UserAuth<T> userAuth;

    protected JsonResult login() {
        T authToken = this.loginViaBasicAuth(this.servletRequest);
        if (authToken == null) {
            authToken = this.loginViaRequestParams(this.servletRequest);
        }
        if (authToken == null) {
            log.warn("Login failed.");
            return JsonResult.of((HttpStatus)HttpStatus.error401().unauthorized("Login failed."));
        }
        log.info("login OK!");
        UserSession<T> userSession = new UserSession<T>(authToken, this.userAuth.tokenValue(authToken));
        userSession.start(this.servletRequest, this.servletResponse);
        return this.tokenAsJson(authToken);
    }

    protected JsonResult tokenAsJson(T authToken) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("token", this.userAuth.tokenValue(authToken));
        return JsonResult.of((Object)jsonObject);
    }

    protected T loginViaRequestParams(HttpServletRequest servletRequest) {
        String username = servletRequest.getParameter(PARAM_USERNAME).trim();
        if (StringUtil.isEmpty((CharSequence)username)) {
            return null;
        }
        String password = servletRequest.getParameter(PARAM_PASSWORD).trim();
        return this.userAuth.login(username, password);
    }

    protected T loginViaBasicAuth(HttpServletRequest servletRequest) {
        String username = ServletUtil.resolveAuthUsername((HttpServletRequest)servletRequest);
        if (username == null) {
            return null;
        }
        String password = ServletUtil.resolveAuthPassword((HttpServletRequest)servletRequest);
        return this.userAuth.login(username, password);
    }

    protected JsonResult logout() {
        log.debug("logout user");
        UserSession.stop(this.servletRequest, this.servletResponse);
        return JsonResult.of((HttpStatus)HttpStatus.ok());
    }
}

