/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import jodd.joy.JoyBase;
import jodd.joy.JoyPropsConfig;
import jodd.props.Props;

public class JoyProps
extends JoyBase
implements JoyPropsConfig {
    protected final Supplier<String> nameSupplier;
    protected Props props;
    private List<String> propsNamePatterns = new ArrayList<String>();
    private List<String> propsProfiles = new ArrayList<String>();

    public JoyProps(Supplier<String> nameSupplier) {
        this.nameSupplier = nameSupplier;
    }

    public Props getProps() {
        return this.requireStarted(this.props);
    }

    @Override
    public JoyProps addPropsFile(String namePattern) {
        this.requireNotStarted(this.props);
        this.propsNamePatterns.add(namePattern);
        return this;
    }

    @Override
    public JoyProps addPropsProfiles(String ... profiles) {
        this.requireNotStarted(this.props);
        Collections.addAll(this.propsProfiles, profiles);
        return this;
    }

    @Override
    public void start() {
        this.initLogger();
        this.log.info("PROPS start ----------");
        this.props = this.createProps();
        this.props.loadSystemProperties("sys");
        this.props.loadEnvironment("env");
        this.log.debug("Loaded sys&env props: " + this.props.countTotalProperties() + " properties.");
        this.props.setActiveProfiles(this.propsProfiles.toArray(new String[0]));
        String[] patterns = new String[this.propsNamePatterns.size() + 1];
        patterns[0] = "/" + this.nameSupplier.get() + "*.prop*";
        for (int i = 0; i < this.propsNamePatterns.size(); ++i) {
            patterns[i + 1] = this.propsNamePatterns.get(i);
        }
        this.log.debug("Loading props from classpath...");
        long startTime = System.currentTimeMillis();
        this.props.loadFromClasspath(patterns);
        this.log.debug("Props scanning completed in " + (System.currentTimeMillis() - startTime) + "ms.");
        this.log.debug("Total properties: " + this.props.countTotalProperties());
        this.log.info("PROPS OK!");
    }

    protected Props createProps() {
        Props props = new Props();
        props.setSkipEmptyProps(true);
        props.setIgnoreMissingMacros(true);
        return props;
    }

    @Override
    public void stop() {
        this.props = null;
    }
}

