/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jodd.chalk.Chalk256;
import jodd.db.DbOom;
import jodd.db.DbSessionProvider;
import jodd.db.connection.ConnectionProvider;
import jodd.db.jtx.DbJtxSessionProvider;
import jodd.db.jtx.DbJtxTransactionManager;
import jodd.db.oom.AutomagicDbOomConfigurator;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbEntityManager;
import jodd.db.pool.CoreConnectionPool;
import jodd.db.querymap.DbPropsQueryMap;
import jodd.db.querymap.QueryMap;
import jodd.joy.JoyBase;
import jodd.joy.JoyDbConfig;
import jodd.joy.JoyPetite;
import jodd.joy.JoyProxetta;
import jodd.joy.JoyScanner;
import jodd.joy.Print;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.proxy.AnnotationTxAdvice;
import jodd.jtx.proxy.AnnotationTxAdviceManager;
import jodd.jtx.proxy.AnnotationTxAdviceSupport;
import jodd.jtx.worker.LeanJtxWorker;
import jodd.petite.PetiteContainer;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.ProxyPointcut;
import jodd.proxetta.pointcuts.MethodWithAnnotationPointcut;
import jodd.util.ClassUtil;
import jodd.util.function.Consumers;

public class JoyDb
extends JoyBase
implements JoyDbConfig {
    protected final Supplier<String> appNameSupplier;
    protected final Supplier<JoyScanner> joyScannerSupplier;
    protected final Supplier<JoyProxetta> joyProxettaSupplier;
    protected final Supplier<JoyPetite> joyPetiteSupplier;
    protected DbOom dbOom;
    protected ConnectionProvider connectionProvider;
    protected JtxTransactionManager jtxManager;
    protected String jtxScopePattern;
    private boolean databaseEnabled = true;
    private boolean autoConfiguration = true;
    private Supplier<ConnectionProvider> connectionProviderSupplier;
    private Consumers<DbEntityManager> dbEntityManagerConsumers = Consumers.empty();

    public JoyDb(Supplier<String> appNameSupplier, Supplier<JoyPetite> joyPetiteSupplier, Supplier<JoyProxetta> joyProxettaSupplier, Supplier<JoyScanner> joyScannerSupplier) {
        this.appNameSupplier = appNameSupplier;
        this.joyPetiteSupplier = joyPetiteSupplier;
        this.joyScannerSupplier = joyScannerSupplier;
        this.joyProxettaSupplier = joyProxettaSupplier;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.requireStarted(this.connectionProvider);
    }

    public JtxTransactionManager getJtxManager() {
        return this.requireStarted(this.jtxManager);
    }

    public boolean isDatabaseEnabled() {
        return this.databaseEnabled;
    }

    @Override
    public JoyDb disableDatabase() {
        this.requireNotStarted(this.connectionProvider);
        this.databaseEnabled = false;
        return this;
    }

    @Override
    public JoyDb disableAutoConfiguration() {
        this.requireNotStarted(this.connectionProvider);
        this.autoConfiguration = false;
        return this;
    }

    @Override
    public JoyDb withEntityManager(Consumer<DbEntityManager> dbEntityManagerConsumer) {
        this.requireNotStarted(this.connectionProvider);
        this.dbEntityManagerConsumers.add(dbEntityManagerConsumer);
        return this;
    }

    @Override
    public JoyDb withConnectionProvider(Supplier<ConnectionProvider> connectionProviderSupplier) {
        this.requireNotStarted(this.connectionProvider);
        this.connectionProviderSupplier = connectionProviderSupplier;
        return this;
    }

    @Override
    public void start() {
        AnnotationTxAdviceManager annTxAdviceManager;
        CoreConnectionPool pool;
        this.initLogger();
        if (!this.databaseEnabled) {
            this.log.info("DB not enabled.");
            return;
        }
        this.log.info("DB start ----------");
        PetiteContainer petiteContainer = this.joyPetiteSupplier.get().getPetiteContainer();
        this.connectionProvider = this.createConnectionProviderIfNotSupplied();
        petiteContainer.addBean(this.beanNamePrefix() + "pool", (Object)this.connectionProvider);
        if (this.connectionProvider instanceof CoreConnectionPool && (pool = (CoreConnectionPool)this.connectionProvider).getDriver() == null) {
            this.databaseEnabled = false;
            this.log.warn("DB configuration not set (" + this.beanNamePrefix() + "pool.*). DB will be disabled.");
            return;
        }
        this.connectionProvider.init();
        this.checkConnectionProvider();
        this.jtxManager = this.createJtxTransactionManager(this.connectionProvider);
        this.jtxManager.setValidateExistingTransaction(true);
        AnnotationTxAdviceSupport.manager = annTxAdviceManager = new AnnotationTxAdviceManager(new LeanJtxWorker(this.jtxManager), this.jtxScopePattern);
        this.joyProxettaSupplier.get().getProxetta().withAspect((Object)this.createTxProxyAspects(annTxAdviceManager.getAnnotations()));
        DbJtxSessionProvider sessionProvider = new DbJtxSessionProvider(this.jtxManager);
        long startTime = System.currentTimeMillis();
        DbPropsQueryMap queryMap = new DbPropsQueryMap();
        this.log.debug("Queries loaded in " + (System.currentTimeMillis() - startTime) + "ms.");
        this.log.debug("Total queries: " + queryMap.size());
        this.dbOom = DbOom.create().withConnectionProvider(this.connectionProvider).withSessionProvider((DbSessionProvider)sessionProvider).withQueryMap((QueryMap)queryMap).get();
        this.dbOom.connect();
        DbEntityManager dbEntityManager = this.dbOom.entityManager();
        dbEntityManager.reset();
        petiteContainer.addBean(this.beanNamePrefix() + "query", (Object)this.dbOom.queryConfig());
        petiteContainer.addBean(this.beanNamePrefix() + "oom", (Object)this.dbOom.config());
        if (this.autoConfiguration) {
            AutomagicDbOomConfigurator automagicDbOomConfigurator = new AutomagicDbOomConfigurator(dbEntityManager, true);
            automagicDbOomConfigurator.registerAsConsumer(this.joyScannerSupplier.get().getClassScanner());
        }
        this.dbEntityManagerConsumers.accept((Object)dbEntityManager);
        this.log.info("DB OK!");
    }

    protected JtxTransactionManager createJtxTransactionManager(ConnectionProvider connectionProvider) {
        return new DbJtxTransactionManager(connectionProvider);
    }

    protected ConnectionProvider createConnectionProviderIfNotSupplied() {
        if (this.connectionProviderSupplier != null) {
            return this.connectionProviderSupplier.get();
        }
        return new CoreConnectionPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionProvider() {
        Connection connection = this.connectionProvider.getConnection();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String name = databaseMetaData.getDatabaseProductName();
            String version = databaseMetaData.getDatabaseProductVersion();
            if (this.log.isInfoEnabled()) {
                this.log.info("Connected to database: " + name + " v" + version);
            }
        }
        catch (SQLException sex) {
            this.log.error("DB connection failed: ", (Throwable)sex);
        }
        finally {
            this.connectionProvider.closeConnection(connection);
        }
    }

    protected ProxyAspect createTxProxyAspects(Class<? extends Annotation>[] annotations) {
        return new ProxyAspect(AnnotationTxAdvice.class, ((ProxyPointcut)MethodInfo::isPublicMethod).and((ProxyPointcut)MethodWithAnnotationPointcut.of((Class[])annotations)));
    }

    @Override
    public void stop() {
        if (!this.databaseEnabled) {
            return;
        }
        if (this.log != null) {
            this.log.info("DB stop");
        }
        if (this.jtxManager != null) {
            this.jtxManager.close();
        }
        this.jtxManager = null;
        if (this.connectionProvider != null) {
            this.connectionProvider.close();
        }
        this.connectionProvider = null;
        if (this.dbOom != null) {
            this.dbOom.shutdown();
        }
        this.dbOom = null;
    }

    protected String beanNamePrefix() {
        String appName = this.appNameSupplier.get();
        return appName + ".db.";
    }

    public void printEntities(int width) {
        if (!this.databaseEnabled) {
            return;
        }
        ArrayList list = new ArrayList();
        this.dbOom.entityManager().forEachEntity(list::add);
        if (list.isEmpty()) {
            return;
        }
        Print print = new Print();
        print.line("Entities", width);
        list.stream().sorted(Comparator.comparing(DbEntityDescriptor::getEntityName)).forEach(ded -> print.outLeftRightNewLine((Chalk256)Chalk256.chalk().yellow(), ded.getTableName(), (Chalk256)Chalk256.chalk().blue(), ClassUtil.getShortClassName((Class)ded.getType(), (int)2), width));
        print.line(width);
    }
}

