/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import jodd.Jodd;
import jodd.chalk.Chalk256;
import jodd.joy.JoddJoyRuntime;
import jodd.joy.JoyDb;
import jodd.joy.JoyDbConfig;
import jodd.joy.JoyInit;
import jodd.joy.JoyMadvoc;
import jodd.joy.JoyPaths;
import jodd.joy.JoyPetite;
import jodd.joy.JoyPetiteConfig;
import jodd.joy.JoyProps;
import jodd.joy.JoyPropsConfig;
import jodd.joy.JoyProxetta;
import jodd.joy.JoyProxettaConfig;
import jodd.joy.JoyScanner;
import jodd.joy.JoyScannerConfig;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.log.LoggerProvider;
import jodd.log.impl.SimpleLogger;
import jodd.madvoc.WebApp;
import jodd.madvoc.petite.PetiteWebApp;
import jodd.petite.PetiteContainer;
import jodd.util.Consumers;

public class JoddJoy {
    public static final String APP_DIR = "app.dir";
    private static JoddJoy joddJoy;
    private String appName = "joy";
    private Supplier<LoggerProvider> loggerProviderSupplier;
    private final JoyPaths joyPaths;
    private final JoyProps joyProps;
    private final Consumers<JoyPropsConfig> joyPropsConsumers = Consumers.empty();
    private final JoyScanner joyScanner;
    private final JoyProxetta joyProxetta;
    private final Consumers<JoyProxettaConfig> joyProxettaConsumers = Consumers.empty();
    private final JoyPetite joyPetite;
    private final Consumers<JoyPetiteConfig> joyPetiteConsumers = Consumers.empty();
    private final JoyDb joyDb;
    private final Consumers<JoyDbConfig> joyDbConsumers = Consumers.empty();
    private final JoyMadvoc joyMadvoc;
    private Logger log;

    public static synchronized JoddJoy get() {
        if (joddJoy == null) {
            joddJoy = new JoddJoy();
        }
        return joddJoy;
    }

    public JoddJoy() {
        this.joyPaths = new JoyPaths();
        this.joyPaths.start();
        this.joyScanner = new JoyScanner();
        this.joyProps = new JoyProps(() -> this.appName);
        this.joyProxetta = new JoyProxetta();
        this.joyPetite = new JoyPetite(() -> this.appName, () -> this.joyProxetta, () -> this.joyProps, () -> this.joyScanner);
        this.joyDb = new JoyDb(() -> this.appName, () -> this.joyPetite, () -> this.joyProxetta, () -> this.joyScanner);
        this.joyMadvoc = new JoyMadvoc(() -> this.appName, () -> this.joyPetite, () -> this.joyProxetta, () -> this.joyProps, () -> this.joyScanner);
    }

    public JoddJoy setApplicationName(String name) {
        Objects.requireNonNull(name);
        this.appName = name;
        return this;
    }

    public JoddJoy withLoggerProvider(Supplier<LoggerProvider> loggerProviderSupplier) {
        this.loggerProviderSupplier = loggerProviderSupplier;
        return this;
    }

    public JoddJoy withProps(Consumer<JoyPropsConfig> propsConsumer) {
        this.joyPropsConsumers.add(propsConsumer);
        return this;
    }

    public JoddJoy withScanner(Consumer<JoyScannerConfig> scannerConsumer) {
        scannerConsumer.accept(this.joyScanner);
        return this;
    }

    public JoddJoy withProxetta(Consumer<JoyProxettaConfig> proxettaConsumer) {
        this.joyProxettaConsumers.add(proxettaConsumer);
        return this;
    }

    public JoddJoy withPetite(Consumer<JoyPetiteConfig> petiteConsumer) {
        this.joyPetiteConsumers.add(petiteConsumer);
        return this;
    }

    public JoddJoy withDb(Consumer<JoyDbConfig> dbConsumer) {
        this.joyDbConsumers.add(dbConsumer);
        return this;
    }

    public JoddJoy withWebApp(Consumer<WebApp> webAppConsumer) {
        this.joyMadvoc.add(webAppConsumer);
        return this;
    }

    public JoddJoy useWebApp(Supplier<PetiteWebApp> webAppSupplier) {
        this.joyMadvoc.setWebAppSupplier(webAppSupplier);
        return this;
    }

    public JoddJoyRuntime startOnlyBackend() {
        return this.start(null);
    }

    public JoddJoyRuntime start(ServletContext servletContext) {
        LoggerProvider loggerProvider = null;
        if (this.loggerProviderSupplier != null) {
            loggerProvider = this.loggerProviderSupplier.get();
        }
        if (loggerProvider == null) {
            loggerProvider = SimpleLogger.PROVIDER;
        }
        LoggerFactory.setLoggerProvider((LoggerProvider)loggerProvider);
        this.log = LoggerFactory.getLogger(JoddJoy.class);
        this.printLogo();
        this.log.info("Ah, Joy!");
        this.log.info("Logging using: " + loggerProvider.getClass().getSimpleName());
        this.joyPropsConsumers.accept((Object)this.joyProps);
        this.joyProxettaConsumers.accept((Object)this.joyProxetta);
        this.joyDbConsumers.accept((Object)this.joyDb);
        this.joyPetiteConsumers.accept((Object)this.joyPetite);
        try {
            this.joyPaths.start();
            this.joyProps.start();
            this.joyProxetta.start();
            this.joyScanner.start();
            this.joyPetite.start();
            this.joyPetite.getPetiteContainer().addBean(this.appName + ".core", (Object)this);
            this.joyPetite.getPetiteContainer().addBean(this.appName + ".scanner", (Object)this.joyScanner);
            this.joyDb.start();
            this.joyMadvoc.setServletContext(servletContext);
            this.joyMadvoc.start();
            this.printJoyConfiguration();
            this.runJoyInitBeans();
            this.joyScanner.stop();
        }
        catch (Exception ex) {
            if (this.log != null) {
                this.log.error(ex.toString(), (Throwable)ex);
            } else {
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            this.stop();
            throw ex;
        }
        if (this.joyDb.isDatabaseEnabled()) {
            return new JoddJoyRuntime(this.appName, this.joyPaths.getAppDir(), this.joyProps.getProps(), this.joyProxetta.getProxetta(), this.joyPetite.getPetiteContainer(), this.joyMadvoc.getWebApp(), this.joyDb.isDatabaseEnabled(), this.joyDb.getConnectionProvider(), this.joyDb.getJtxManager());
        }
        return new JoddJoyRuntime(this.appName, this.joyPaths.getAppDir(), this.joyProps.getProps(), this.joyProxetta.getProxetta(), this.joyPetite.getPetiteContainer(), this.joyMadvoc.getWebApp());
    }

    private void printJoyConfiguration() {
        this.joyPetite.printBeans(100);
        this.joyDb.printEntities(100);
        this.joyMadvoc.printRoutes(100);
        System.out.println(((Chalk256)Chalk256.chalk().yellow()).on("Joy") + " is up. Enjoy!");
        this.log.info("Joy is up. Enjoy!");
    }

    private void printLogo() {
        System.out.println(((Chalk256)Chalk256.chalk().yellow()).on(Jodd.JODD));
    }

    public void stop() {
        this.joyProps.stop();
        try {
            this.joyDb.stop();
            this.joyPetite.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.log != null) {
            this.log.info("Joy is down. Bye, bye!");
        }
    }

    protected void runJoyInitBeans() {
        PetiteContainer pc = this.joyPetite.getPetiteContainer();
        pc.forEachBeanType(JoyInit.class, beanName -> {
            JoyInit joyInit = (JoyInit)pc.getBean(beanName);
            if (joyInit != null) {
                joyInit.onJoy();
            }
        });
    }
}

