/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.net.MalformedURLException;
import java.net.URL;
import jodd.joy.JoyBase;
import jodd.joy.JoyException;
import jodd.system.SystemUtil;
import jodd.util.ResourcesUtil;
import jodd.util.StringUtil;

public class JoyPaths
extends JoyBase {
    protected String appDir;

    public String getAppDir() {
        return this.requireStarted(this.appDir);
    }

    @Override
    public void start() {
        this.initLogger();
        String resourceName = StringUtil.replaceChar((String)JoyPaths.class.getName(), (char)'.', (char)'/') + ".class";
        URL url = ResourcesUtil.getResourceUrl((String)resourceName);
        if (url == null) {
            throw new JoyException("Failed to resolve app dir, missing: " + resourceName);
        }
        String protocol = url.getProtocol();
        if (!protocol.equals("file")) {
            try {
                url = new URL(url.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.appDir = url.getFile();
        int ndx = this.appDir.indexOf("WEB-INF");
        this.appDir = ndx > 0 ? this.appDir.substring(0, ndx) : SystemUtil.info().getWorkingDir();
        System.setProperty("app.dir", this.appDir);
        this.log.info("Application folder: " + this.appDir);
    }

    @Override
    public void stop() {
    }
}

