/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import jodd.joy.JoyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JoyBase {
    protected Logger log;

    protected JoyBase() {
    }

    protected void initLogger() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public abstract void start();

    public abstract void stop();

    protected void requireNotStarted(Object object) {
        if (object != null) {
            throw new JoyException("Configuration is modified after component is started.");
        }
    }

    protected <T> T requireStarted(T object) {
        if (object == null) {
            throw new JoyException("Component is not started yet and can not be used.");
        }
        return object;
    }
}

