/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.EnumSet;
import java.util.Objects;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import jodd.decora.DecoraServletFilter;
import jodd.joy.JoddJoy;
import jodd.joy.JoyException;
import jodd.madvoc.MadvocServletFilter;
import jodd.servlet.RequestContextListener;
import jodd.util.ClassUtil;
import jodd.util.SystemUtil;

public class JoyContextListener
implements ServletContextListener {
    protected boolean decoraEnabled = false;
    protected String contextPath = "/*";
    protected EnumSet<DispatcherType> madvocDispatcherTypes = EnumSet.of(DispatcherType.REQUEST);

    public static void registerInServletContext(ServletContext servletContext, Class<? extends JoyContextListener> joyContextListenerClass) {
        try {
            JoyContextListener joyContextListener = (JoyContextListener)ClassUtil.newInstance(joyContextListenerClass);
            joyContextListener.createJoyAndInitServletContext(servletContext);
        }
        catch (Exception e) {
            throw new JoyException(e);
        }
        servletContext.addListener(joyContextListenerClass);
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        this.createJoyAndInitServletContext(servletContext).start(servletContext);
    }

    private JoddJoy createJoyAndInitServletContext(ServletContext servletContext) {
        JoddJoy joy = (JoddJoy)servletContext.getAttribute(JoddJoy.class.getName());
        if (joy == null) {
            joy = this.createJoy();
            this.configureServletContext(servletContext);
        }
        servletContext.setAttribute(JoddJoy.class.getName(), (Object)joy);
        return joy;
    }

    protected JoddJoy createJoy() {
        JoddJoy joy = JoddJoy.get();
        if (SystemUtil.info().isAtLeastJavaVersion(9)) {
            joy.withScanner(joyScanner -> joyScanner.scanClasspathOf(this.getClass()));
        }
        return joy;
    }

    protected void enableDecora() {
        this.decoraEnabled = true;
    }

    protected void setMadvocContextPath(String context) {
        Objects.requireNonNull(context);
        this.contextPath = context;
    }

    protected void mapMadvocFilterFor(EnumSet<DispatcherType> dispatcherTypeEnumSet) {
        this.madvocDispatcherTypes = dispatcherTypeEnumSet;
    }

    private void configureServletContext(ServletContext servletContext) {
        FilterRegistration.Dynamic filter;
        servletContext.addListener(RequestContextListener.class);
        if (this.decoraEnabled) {
            filter = servletContext.addFilter("decora", DecoraServletFilter.class);
            filter.addMappingForUrlPatterns(null, true, new String[]{this.contextPath});
        }
        filter = servletContext.addFilter("madvoc", MadvocServletFilter.class);
        filter.addMappingForUrlPatterns(this.madvocDispatcherTypes, true, new String[]{this.contextPath});
    }

    public void contextDestroyed(ServletContextEvent sce) {
        JoddJoy.get().stop();
    }
}

