/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jodd.jtx.JtxTransactionMode;
import jodd.jtx.meta.ReadOnlyTransaction;
import jodd.jtx.meta.ReadWriteTransaction;
import jodd.jtx.meta.Transaction;
import jodd.jtx.meta.TransactionAnnotationValues;
import jodd.jtx.worker.LeanJtxWorker;
import jodd.proxetta.ProxettaException;
import jodd.util.StringUtil;
import jodd.util.annotation.AnnotationParser;

public class AnnotationTxAdviceManager {
    protected static final String JTXCTX_PATTERN_CLASS = "$class";
    protected static final String JTXCTX_PATTERN_METHOD = "$method";
    protected final Map<String, JtxTransactionMode> txmap = new HashMap<String, JtxTransactionMode>();
    protected final LeanJtxWorker jtxWorker;
    protected final JtxTransactionMode defaultTransactionMode;
    protected final String scopePattern;
    protected Class<? extends Annotation>[] annotations;
    protected AnnotationParser[] annotationParsers;

    public AnnotationTxAdviceManager(LeanJtxWorker jtxWorker) {
        this(jtxWorker, "$class#$method", null);
    }

    public AnnotationTxAdviceManager(LeanJtxWorker jtxWorker, String scopePattern) {
        this(jtxWorker, scopePattern, null);
    }

    public AnnotationTxAdviceManager(LeanJtxWorker jtxWorker, String scopePattern, JtxTransactionMode defaultTxMode) {
        this.jtxWorker = jtxWorker;
        this.defaultTransactionMode = defaultTxMode == null ? JtxTransactionMode.PROPAGATION_SUPPORTS_READ_ONLY : defaultTxMode;
        this.scopePattern = scopePattern;
        this.registerAnnotations(new Class[]{Transaction.class, ReadWriteTransaction.class, ReadOnlyTransaction.class});
    }

    public LeanJtxWorker getJtxWorker() {
        return this.jtxWorker;
    }

    public JtxTransactionMode getDefaultTransactionMode() {
        return this.defaultTransactionMode;
    }

    public String resolveScope(Class type, String methodName) {
        if (this.scopePattern == null) {
            return null;
        }
        String ctx = this.scopePattern;
        ctx = StringUtil.replace((String)ctx, (String)JTXCTX_PATTERN_CLASS, (String)type.getName());
        ctx = StringUtil.replace((String)ctx, (String)JTXCTX_PATTERN_METHOD, (String)methodName);
        return ctx;
    }

    public synchronized JtxTransactionMode getTxMode(Class type, String methodName, Class[] methodArgTypes, String unique) {
        String signature = type.getName() + '#' + methodName + '%' + unique;
        JtxTransactionMode txMode = this.txmap.get(signature);
        if (txMode == null && !this.txmap.containsKey(signature)) {
            Method m;
            try {
                m = type.getMethod(methodName, methodArgTypes);
            }
            catch (NoSuchMethodException nsmex) {
                throw new ProxettaException((Throwable)nsmex);
            }
            TransactionAnnotationValues txAnn = this.readTransactionAnnotation(m);
            txMode = txAnn != null ? new JtxTransactionMode(txAnn.propagation(), txAnn.isolation(), txAnn.readOnly(), txAnn.timeout()) : this.defaultTransactionMode;
            this.txmap.put(signature, txMode);
        }
        return txMode;
    }

    public Class<? extends Annotation>[] getAnnotations() {
        return this.annotations;
    }

    public void registerAnnotations(Class<? extends Annotation>[] annotations) {
        this.annotations = annotations;
        this.annotationParsers = new AnnotationParser[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            this.annotationParsers[i] = TransactionAnnotationValues.parserFor(annotations[i]);
        }
    }

    protected TransactionAnnotationValues readTransactionAnnotation(Method method) {
        for (AnnotationParser annotationParser : this.annotationParsers) {
            TransactionAnnotationValues tad = TransactionAnnotationValues.of(annotationParser, method);
            if (tad == null) continue;
            return tad;
        }
        return null;
    }
}

