/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora.parser;

import java.io.IOException;
import java.io.Writer;
import jodd.decora.parser.DecoraTag;
import jodd.decora.parser.DecoratorTagVisitor;
import jodd.decora.parser.PageRegionExtractor;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.TagVisitor;

public class DecoraParser {
    public void decorate(Writer writer, char[] pageContent, char[] decoraContent) throws IOException {
        DecoraTag[] decoraTags = this.parseDecorator(decoraContent);
        this.parsePage(pageContent, decoraTags);
        this.writeDecoratedPage(writer, decoraContent, pageContent, decoraTags);
    }

    protected DecoraTag[] parseDecorator(char[] decoraContent) {
        LagartoParser lagartoParser = new LagartoParser(decoraContent);
        DecoratorTagVisitor visitor = new DecoratorTagVisitor();
        lagartoParser.parse((TagVisitor)visitor);
        return visitor.getDecoraTags();
    }

    protected void parsePage(char[] pageContent, DecoraTag[] decoraTags) {
        LagartoParser lagartoParser = new LagartoParser(pageContent);
        PageRegionExtractor writer = new PageRegionExtractor(decoraTags);
        lagartoParser.parse((TagVisitor)writer);
    }

    protected void writeDecoratedPage(Writer out, char[] decoratorContent, char[] pageContent, DecoraTag[] decoraTags) throws IOException {
        int ndx = 0;
        for (DecoraTag decoraTag : decoraTags) {
            int decoratorLen = decoraTag.getStartIndex() - ndx;
            if (decoratorLen <= 0) continue;
            out.write(decoratorContent, ndx, decoratorLen);
            ndx = decoraTag.getEndIndex();
            int regionLen = decoraTag.getRegionLength();
            if (regionLen == 0) {
                if (!decoraTag.hasDefaultValue()) continue;
                out.write(decoratorContent, decoraTag.getDefaultValueStart(), decoraTag.getDefaultValueLength());
                continue;
            }
            this.writeRegion(out, pageContent, decoraTag, decoraTags);
        }
        out.write(decoratorContent, ndx, decoratorContent.length - ndx);
    }

    protected void writeRegion(Writer out, char[] pageContent, DecoraTag decoraTag, DecoraTag[] decoraTags) throws IOException {
        int regionStart = decoraTag.getRegionStart();
        int regionLen = decoraTag.getRegionLength();
        int regionEnd = regionStart + regionLen;
        for (DecoraTag decoraTag2 : decoraTags) {
            int regionStart2;
            if (decoraTag == decoraTag2 || decoraTag.isRegionUndefined() || (regionStart2 = decoraTag2.getRegionStart()) <= regionStart || regionStart2 >= regionEnd) continue;
            out.write(pageContent, regionStart, decoraTag2.getRegionTagStart() - regionStart);
            regionStart = decoraTag2.getRegionTagEnd();
        }
        out.write(pageContent, regionStart, regionEnd - regionStart);
    }
}

