/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora.parser;

import jodd.decora.DecoraException;
import jodd.decora.parser.DecoraTag;
import jodd.lagarto.EmptyTagVisitor;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;

public class PageRegionExtractor
extends EmptyTagVisitor {
    protected final DecoraTag[] decoraTags;
    protected int currentRegions;

    public PageRegionExtractor(DecoraTag[] decoraTags) {
        this.decoraTags = decoraTags;
    }

    public void tag(Tag tag) {
        if (tag.getType() == TagType.END) {
            if (this.currentRegions > 0) {
                for (DecoraTag decoraTag : this.decoraTags) {
                    if (!decoraTag.isRegionStarted() || !decoraTag.getName().equals(tag.getName())) continue;
                    decoraTag.endRegion(tag.getTagPosition(), tag.getTagLength());
                    --this.currentRegions;
                }
            }
            return;
        }
        if (tag.getType() == TagType.SELF_CLOSING) {
            return;
        }
        for (DecoraTag decoraTag : this.decoraTags) {
            if (!decoraTag.isRegionUndefined() || !decoraTag.isMatchedTag(tag)) continue;
            decoraTag.startRegion(tag.getTagPosition(), tag.getTagLength());
            ++this.currentRegions;
        }
    }

    public void end() {
        if (this.currentRegions != 0) {
            throw new DecoraException("Some regions are not defined correctly");
        }
    }
}

