/*
 * Decompiled with CFR 0.152.
 */
package jodd.htmlstapler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.bean.BeanUtil;
import jodd.datetime.TimeUtil;
import jodd.htmlstapler.HtmlStaplerBundlesManager;
import jodd.htmlstapler.HtmlStaplerTagAdapter;
import jodd.io.StreamUtil;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.TagWriter;
import jodd.lagarto.adapter.StripHtmlTagAdapter;
import jodd.lagarto.filter.SimpleLagartoServletFilter;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.servlet.DispatcherUtil;
import jodd.servlet.ServletUtil;
import jodd.util.MimeTypes;

public class HtmlStaplerFilter
extends SimpleLagartoServletFilter {
    private static final Logger log = LoggerFactory.getLogger(HtmlStaplerFilter.class);
    protected HtmlStaplerBundlesManager bundlesManager;
    protected boolean enabled = true;
    protected boolean stripHtml = true;
    protected boolean resetOnStart = true;
    protected boolean useGzip;
    protected int cacheMaxAge = 2592000;
    protected HtmlStaplerBundlesManager.Strategy staplerStrategy = HtmlStaplerBundlesManager.Strategy.RESOURCES_ONLY;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.bundlesManager = this.createBundleManager(filterConfig.getServletContext(), this.staplerStrategy);
        this.readFilterConfigParameters(filterConfig, this, "enabled", "stripHtml", "resetOnStart", "useGzip", "cacheMaxAge");
        String staplerStrategyName = filterConfig.getInitParameter("strategy");
        if (staplerStrategyName != null && staplerStrategyName.equalsIgnoreCase("ACTION_MANAGED")) {
            this.staplerStrategy = HtmlStaplerBundlesManager.Strategy.ACTION_MANAGED;
        }
        this.readFilterConfigParameters(filterConfig, this.bundlesManager, "bundleFolder", "downloadLocal", "localAddressAndPort", "localFilesEncoding", "notFoundExceptionEnabled", "sortResources", "staplerPath");
        if (this.resetOnStart) {
            this.bundlesManager.reset();
        }
    }

    protected void readFilterConfigParameters(FilterConfig filterConfig, Object target, String ... parameters) {
        for (String parameter : parameters) {
            String value = filterConfig.getInitParameter(parameter);
            if (value == null) continue;
            BeanUtil.setDeclaredProperty((Object)target, (String)parameter, (Object)value);
        }
    }

    protected HtmlStaplerBundlesManager createBundleManager(ServletContext servletContext, HtmlStaplerBundlesManager.Strategy strategy) {
        String webRoot = servletContext.getRealPath("");
        String contextPath = ServletUtil.getContextPath((ServletContext)servletContext);
        return new HtmlStaplerBundlesManager(contextPath, webRoot, strategy);
    }

    protected SimpleLagartoServletFilter.LagartoParsingProcessor createParsingProcessor() {
        if (!this.enabled) {
            return null;
        }
        return new SimpleLagartoServletFilter.LagartoParsingProcessor(true){

            protected char[] parse(TagWriter rootTagWriter, HttpServletRequest request) {
                Object visitor = rootTagWriter;
                if (HtmlStaplerFilter.this.stripHtml) {
                    visitor = new StripHtmlTagAdapter((TagVisitor)rootTagWriter){

                        public void end() {
                            super.end();
                            if (log.isDebugEnabled()) {
                                log.debug("Stripped: " + this.getStrippedCharsCount() + " chars.");
                            }
                        }
                    };
                }
                String servletPath = DispatcherUtil.getServletPath((HttpServletRequest)request);
                HtmlStaplerTagAdapter htmlStaplerTagAdapter = new HtmlStaplerTagAdapter(HtmlStaplerFilter.this.bundlesManager, servletPath, (TagVisitor)visitor);
                char[] content = this.invokeLagarto(htmlStaplerTagAdapter);
                return htmlStaplerTagAdapter.postProcess(content);
            }
        };
    }

    protected boolean processActionPath(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String actionPath) throws IOException {
        String bundlePath = '/' + this.bundlesManager.getStaplerPath() + '/';
        if (!actionPath.startsWith(bundlePath)) {
            return false;
        }
        String bundleId = actionPath.substring(bundlePath.length());
        File file = this.bundlesManager.lookupBundleFile(bundleId);
        if (log.isDebugEnabled()) {
            log.debug("bundle: " + bundleId);
        }
        int ndx = bundleId.lastIndexOf(46);
        String extension = bundleId.substring(ndx + 1);
        String contentType = MimeTypes.getMimeType((String)extension);
        servletResponse.setContentType(contentType);
        if (this.useGzip && ServletUtil.isGzipSupported((HttpServletRequest)servletRequest)) {
            file = this.bundlesManager.lookupGzipBundleFile(file);
            servletResponse.setHeader("Content-Encoding", "gzip");
        }
        if (!file.exists()) {
            throw new IOException("bundle not found: " + bundleId);
        }
        servletResponse.setHeader("Content-Length", String.valueOf(file.length()));
        servletResponse.setHeader("Last-Modified", TimeUtil.formatHttpDate((long)file.lastModified()));
        if (this.cacheMaxAge > 0) {
            servletResponse.setHeader("Cache-Control", "max-age=" + this.cacheMaxAge);
        }
        this.sendBundleFile(servletResponse, file);
        return true;
    }

    protected void sendBundleFile(HttpServletResponse resp, File bundleFile) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        StreamUtil.copy((InputStream)new FileInputStream(bundleFile), (OutputStream)out);
    }
}

