/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.form;

import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagWriter;
import jodd.lagarto.form.FormFieldResolver;
import jodd.util.StringUtil;

public class FormProcessorVisitor
extends TagWriter {
    private static final char[] INPUT = new char[]{'i', 'n', 'p', 'u', 't'};
    private static final char[] TYPE = new char[]{'t', 'y', 'p', 'e'};
    private static final char[] SELECT = new char[]{'s', 'e', 'l', 'e', 'c', 't'};
    private static final char[] OPTION = new char[]{'o', 'p', 't', 'i', 'o', 'n'};
    private static final char[] TEXTAREA = new char[]{'t', 'e', 'x', 't', 'a', 'r', 'e', 'a'};
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String TEXT = "text";
    private static final String HIDDEN = "hidden";
    private static final String IMAGE = "image";
    private static final String PASSWORD = "password";
    private static final String CHECKBOX = "checkbox";
    private static final String TRUE = "true";
    private static final String CHECKED = "checked";
    private static final String RADIO = "radio";
    private static final String SELECTED = "selected";
    private final FormFieldResolver resolver;
    private boolean inSelect;
    private String currentSelectName;
    private String textAreaValue;
    private boolean inTextArea;

    public FormProcessorVisitor(Appendable appendable, FormFieldResolver resolver) {
        super(appendable);
        this.resolver = resolver;
    }

    public void tag(Tag tag) {
        if (tag.getType().isStartingTag()) {
            if (tag.matchTagName(INPUT)) {
                this.processInputStartTag(tag);
                super.tag(tag);
                return;
            }
            if (this.inSelect && tag.matchTagName(OPTION)) {
                this.processOptionOpenTag(tag);
                super.tag(tag);
                return;
            }
        }
        if (tag.getType() == TagType.START) {
            if (tag.matchTagName(TEXTAREA)) {
                this.processTextareaStartTag(tag);
            } else if (tag.matchTagName(SELECT)) {
                this.processSelectOpenTag(tag);
            }
        } else if (tag.getType() == TagType.END) {
            if (this.inTextArea && tag.matchTagName(TEXTAREA)) {
                this.processTextareaEndTag();
            } else if (this.inSelect && tag.matchTagName(SELECT)) {
                this.processSelectEndTag();
            }
        }
        super.tag(tag);
    }

    public void text(CharSequence text) {
        if (this.inTextArea) {
            return;
        }
        super.text(text);
    }

    private void processInputStartTag(Tag tag) {
        CharSequence tagValue;
        CharSequence tagType = tag.getAttributeValue(TYPE);
        if (tagType == null) {
            return;
        }
        CharSequence name = tag.getAttributeValue((CharSequence)NAME);
        if (name == null) {
            return;
        }
        Object valueObject = this.resolver.value(name.toString());
        if (valueObject == null) {
            return;
        }
        String value = valueObject.toString();
        String tagTypeName = tagType.toString().toLowerCase();
        if (tagTypeName.equals(TEXT)) {
            tag.setAttribute((CharSequence)VALUE, (CharSequence)value);
        } else if (tagTypeName.equals(HIDDEN)) {
            tag.setAttribute((CharSequence)VALUE, (CharSequence)value);
        } else if (tagTypeName.equals(IMAGE)) {
            tag.setAttribute((CharSequence)VALUE, (CharSequence)value);
        } else if (tagTypeName.equals(PASSWORD)) {
            tag.setAttribute((CharSequence)VALUE, (CharSequence)value);
        } else if (tagTypeName.equals(CHECKBOX)) {
            CharSequence tagValue2 = tag.getAttributeValue((CharSequence)VALUE);
            if (tagValue2 == null) {
                tagValue2 = TRUE;
            }
            tagValue2 = tagValue2.toString();
            if (valueObject.getClass().isArray()) {
                String[] vs;
                for (String vsk : vs = StringUtil.toStringArray((Object)valueObject)) {
                    if (vsk == null || !vsk.equals(tagValue2)) continue;
                    tag.setAttribute((CharSequence)CHECKED, null);
                }
            } else if (tagValue2.equals(value)) {
                tag.setAttribute((CharSequence)CHECKED, null);
            }
        } else if (tagType.equals(RADIO) && (tagValue = tag.getAttributeValue((CharSequence)VALUE)) != null && (tagValue = tagValue.toString()).equals(value)) {
            tag.setAttribute((CharSequence)CHECKED, null);
        }
    }

    private void processSelectOpenTag(Tag tag) {
        CharSequence name = tag.getAttributeValue((CharSequence)NAME);
        if (name == null) {
            return;
        }
        this.currentSelectName = name.toString();
        this.inSelect = true;
    }

    private void processSelectEndTag() {
        this.inSelect = false;
        this.currentSelectName = null;
    }

    private void processOptionOpenTag(Tag tag) {
        CharSequence tagValue = tag.getAttributeValue((CharSequence)VALUE);
        if (tagValue == null) {
            return;
        }
        Object vals = this.resolver.value(this.currentSelectName);
        if (vals == null) {
            return;
        }
        tagValue = tagValue.toString();
        if (vals.getClass().isArray()) {
            String[] vs;
            for (String vsk : vs = StringUtil.toStringArray((Object)vals)) {
                if (vsk == null || !vsk.equals(tagValue)) continue;
                tag.setAttribute((CharSequence)SELECTED, null);
            }
        } else {
            String value = StringUtil.toString((Object)vals);
            if (value.equals(tagValue)) {
                tag.setAttribute((CharSequence)SELECTED, null);
            }
        }
    }

    private void processTextareaStartTag(Tag tag) {
        this.inTextArea = true;
        CharSequence name = tag.getAttributeValue((CharSequence)NAME);
        if (name == null) {
            return;
        }
        Object valueObject = this.resolver.value(name.toString());
        if (valueObject != null) {
            this.textAreaValue = valueObject.toString();
        }
    }

    private void processTextareaEndTag() {
        this.inTextArea = false;
        if (this.textAreaValue == null) {
            return;
        }
        super.text((CharSequence)this.textAreaValue);
        this.textAreaValue = null;
    }
}

