/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora.parser;

import jodd.lagarto.Tag;
import jodd.lagarto.TagUtil;

public class DecoraTag {
    private final String name;
    private final String id;
    private final int start;
    private final int end;
    private final int defaultValueStart;
    private final int defaultValueLength;
    private int regionStart = -1;
    private int regionLength;
    private int regionTagStart;
    private int regionTagEnd;

    public DecoraTag(String name, String id, int start, int end) {
        this(name, id, start, end, -1, 0);
    }

    public DecoraTag(String name, String id, int start, int end, int defaultValueStart, int defaultValueLength) {
        this.name = name;
        this.id = id;
        this.start = start;
        this.end = end;
        if (defaultValueLength == 0) {
            defaultValueStart = -1;
        }
        this.defaultValueStart = defaultValueStart;
        this.defaultValueLength = defaultValueLength;
    }

    public DecoraTag duplicate() {
        return new DecoraTag(this.name, this.id, this.start, this.end, this.defaultValueStart, this.defaultValueLength);
    }

    public String getName() {
        return this.name;
    }

    public int getStartIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getDefaultValueStart() {
        return this.defaultValueStart;
    }

    public int getDefaultValueLength() {
        return this.defaultValueLength;
    }

    public boolean hasDefaultValue() {
        return this.defaultValueStart != -1;
    }

    public boolean isMatchedTag(Tag tag) {
        CharSequence tagId;
        if (!tag.nameEquals((CharSequence)this.name)) {
            return false;
        }
        return this.id == null || (tagId = tag.getId()) == null || TagUtil.equals((CharSequence)this.id, (CharSequence)tagId);
    }

    public boolean isRegionDefined() {
        return this.regionLength != 0;
    }

    public boolean isRegionStarted() {
        return this.regionStart != -1 && this.regionLength == 0;
    }

    public boolean isRegionUndefined() {
        return this.regionStart == -1;
    }

    public void startRegion(int start, int tagLen) {
        this.regionStart = start + tagLen;
        this.regionLength = 0;
        this.regionTagStart = start;
    }

    public void endRegion(int regionEnd, int tagLen) {
        this.regionLength = regionEnd - this.regionStart;
        this.regionTagEnd = regionEnd + tagLen;
    }

    public int getRegionStart() {
        return this.regionStart;
    }

    public int getRegionLength() {
        return this.regionLength;
    }

    public int getRegionTagStart() {
        return this.regionTagStart;
    }

    public int getRegionTagEnd() {
        return this.regionTagEnd;
    }

    public String toString() {
        return "DecoraTag{name='" + this.name + '\'' + ", start=" + this.start + ", end=" + this.end + ", regionStart=" + this.regionStart + ", regionLength=" + this.regionLength + '}';
    }
}

