/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.mail.EmailAttachment;
import jodd.mail.MailException;
import jodd.mail.att.ByteArrayAttachment;
import jodd.mail.att.FileAttachment;
import jodd.mail.att.InputStreamAttachment;
import jodd.util.MimeTypes;

public class EmailAttachmentBuilder {
    private byte[] sourceBytes;
    private File sourceFile;
    private InputStream sourceInputStream;
    private String contentType;
    private String name;
    private String contentId;
    private boolean inline;

    protected EmailAttachmentBuilder() {
    }

    public EmailAttachmentBuilder bytes(byte[] bytes) {
        this.checkIfSourceSpecified();
        this.sourceBytes = bytes;
        return this;
    }

    public EmailAttachmentBuilder bytes(InputStream inputStream) {
        this.checkIfSourceSpecified();
        try {
            this.sourceBytes = StreamUtil.readBytes((InputStream)inputStream);
        }
        catch (IOException ioex) {
            throw new MailException(ioex);
        }
        return this;
    }

    public EmailAttachmentBuilder bytes(File file) {
        this.checkIfSourceSpecified();
        try {
            this.sourceBytes = FileUtil.readBytes((File)file);
            this.name = file.getName();
        }
        catch (IOException ioex) {
            throw new MailException(ioex);
        }
        return this;
    }

    public EmailAttachmentBuilder file(File file) {
        this.checkIfSourceSpecified();
        this.sourceFile = file;
        this.name = file.getName();
        return this;
    }

    public EmailAttachmentBuilder file(String fileName) {
        this.file(new File(fileName));
        return this;
    }

    public EmailAttachmentBuilder stream(InputStream inputStream) {
        this.checkIfSourceSpecified();
        this.sourceInputStream = inputStream;
        return this;
    }

    public EmailAttachmentBuilder stream(File file) {
        this.checkIfSourceSpecified();
        try {
            this.sourceInputStream = new FileInputStream(file);
            this.name = file.getName();
        }
        catch (FileNotFoundException fnfex) {
            throw new MailException(fnfex);
        }
        return this;
    }

    public EmailAttachmentBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public EmailAttachmentBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public EmailAttachmentBuilder setInline(boolean inline) {
        this.inline = inline;
        if (!inline) {
            this.contentId = null;
        }
        return this;
    }

    public EmailAttachmentBuilder setInline(String contentId) {
        if (contentId != null) {
            this.inline = true;
            this.contentId = contentId;
        } else {
            this.inline = false;
            this.contentId = null;
        }
        return this;
    }

    public EmailAttachment create() {
        if (this.sourceBytes != null) {
            return this.createByteArrayAttachment();
        }
        if (this.sourceInputStream != null) {
            return this.createInputStreamAttachment();
        }
        if (this.sourceFile != null) {
            return this.createFileAttachment();
        }
        throw new MailException();
    }

    protected void checkIfSourceSpecified() {
        int count = 0;
        if (this.sourceFile != null) {
            ++count;
        }
        if (this.sourceBytes != null) {
            ++count;
        }
        if (this.sourceInputStream != null) {
            ++count;
        }
        if (count > 0) {
            throw new MailException("Attachment source already specified.");
        }
    }

    protected ByteArrayAttachment createByteArrayAttachment() {
        String name = this.name;
        String contentType = this.resolveContentType();
        String contentId = this.resolveContentId();
        return new ByteArrayAttachment(this.sourceBytes, contentType, name, contentId);
    }

    protected InputStreamAttachment createInputStreamAttachment() {
        String name = this.name;
        String contentType = this.resolveContentType();
        String contentId = this.resolveContentId();
        return new InputStreamAttachment(this.sourceInputStream, contentType, name, contentId);
    }

    protected FileAttachment createFileAttachment() {
        String name = this.name;
        String contentId = this.resolveContentId();
        return new FileAttachment(this.sourceFile, name, contentId);
    }

    protected String resolveContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.name == null) {
            return "application/octet-stream";
        }
        String extension = FileNameUtil.getExtension((String)this.name);
        return MimeTypes.getMimeType((String)extension);
    }

    protected String resolveContentId() {
        if (this.inline) {
            if (this.contentId != null) {
                return this.contentId;
            }
            return FileNameUtil.getName((String)this.name);
        }
        return null;
    }
}

