/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimePart;
import jodd.JoddCore;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.StreamUtil;
import jodd.mail.MailException;
import jodd.mail.ReceivedEmail;
import jodd.util.CharUtil;

public class ReceiveMailSession {
    protected static final String DEFAULT_FOLDER = "INBOX";
    protected static final String STR_CHARSET = "charset=";
    protected final Session session;
    protected final Store store;
    protected Folder folder;

    public ReceiveMailSession(Session session, Store store) {
        this.session = session;
        this.store = store;
    }

    public void open() {
        try {
            this.store.connect();
        }
        catch (MessagingException msex) {
            throw new MailException("Unable to open session", msex);
        }
    }

    public void useFolder(String folderName) {
        this.closeFolderIfOpened();
        try {
            this.folder = this.store.getFolder(folderName);
        }
        catch (MessagingException msex) {
            throw new MailException("Unable to connect to folder: " + folderName, msex);
        }
        try {
            this.folder.open(2);
        }
        catch (MessagingException mex) {
            try {
                this.folder.open(1);
            }
            catch (MessagingException msex) {
                throw new MailException("Unable to open folder: " + folderName, msex);
            }
        }
    }

    public void useDefaultFolder() {
        this.closeFolderIfOpened();
        this.useFolder(DEFAULT_FOLDER);
    }

    public int getMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getMessageCount();
        }
        catch (MessagingException mex) {
            throw new MailException("Unable to read number of messages", mex);
        }
    }

    public int getNewMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getNewMessageCount();
        }
        catch (MessagingException mex) {
            throw new MailException("Unable to read number of new messages", mex);
        }
    }

    public ReceivedEmail[] receiveEmail(boolean delete) {
        ReceivedEmail[] emails;
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            Message[] messages = this.folder.getMessages();
            if (messages.length == 0) {
                return null;
            }
            emails = new ReceivedEmail[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                Message msg = messages[i];
                if (delete) {
                    msg.setFlag(Flags.Flag.DELETED, true);
                }
                emails[i] = this.message2Email(msg);
            }
        }
        catch (MessagingException msex) {
            throw new MailException("Unable to read messages", msex);
        }
        catch (IOException ioex) {
            throw new MailException("Unable to read message content", ioex);
        }
        return emails;
    }

    protected ReceivedEmail message2Email(Message msg) throws MessagingException, IOException {
        ReceivedEmail email = new ReceivedEmail();
        if (msg.isSet(Flags.Flag.ANSWERED)) {
            email.addFlags(1);
        }
        if (msg.isSet(Flags.Flag.DELETED)) {
            email.addFlags(2);
        }
        if (msg.isSet(Flags.Flag.DRAFT)) {
            email.addFlags(4);
        }
        if (msg.isSet(Flags.Flag.FLAGGED)) {
            email.addFlags(8);
        }
        if (msg.isSet(Flags.Flag.RECENT)) {
            email.addFlags(16);
        }
        if (msg.isSet(Flags.Flag.SEEN)) {
            email.addFlags(32);
        }
        if (msg.isSet(Flags.Flag.USER)) {
            email.addFlags(Integer.MIN_VALUE);
        }
        email.setMessageNumber(msg.getMessageNumber());
        email.setFrom(msg.getFrom()[0].toString());
        email.setTo(this.address2String(msg.getRecipients(Message.RecipientType.TO)));
        email.setCc(this.address2String(msg.getRecipients(Message.RecipientType.CC)));
        email.setBcc(this.address2String(msg.getRecipients(Message.RecipientType.BCC)));
        email.setSubject(msg.getSubject());
        Date recvDate = msg.getReceivedDate();
        if (recvDate == null) {
            recvDate = new Date();
        }
        email.setReceiveDate(recvDate);
        email.setSentDate(msg.getSentDate());
        Enumeration headers = msg.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            email.setHeader(header.getName(), header.getValue());
        }
        this.processPart(email, (Part)msg);
        return email;
    }

    protected void processPart(ReceivedEmail email, Part part) throws IOException, MessagingException {
        Object content = part.getContent();
        if (content instanceof String) {
            String stringContent = (String)content;
            String disposition = part.getDisposition();
            if (disposition != null && disposition.equals("attachment")) {
                String mimeType = this.extractMimeType(part.getContentType());
                String fileName = part.getFileName();
                String contentId = part instanceof MimePart ? ((MimePart)part).getContentID() : null;
                email.addAttachment(fileName, mimeType, contentId, stringContent.getBytes(JoddCore.encoding));
            } else {
                String contentType = part.getContentType();
                email.addMessage(stringContent, this.extractMimeType(contentType), this.extractEncoding(contentType));
            }
        } else if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                BodyPart innerPart = mp.getBodyPart(i);
                this.processPart(email, (Part)innerPart);
            }
        } else if (content instanceof InputStream) {
            String fileName = part.getFileName();
            String contentId = part instanceof MimePart ? ((MimePart)part).getContentID() : null;
            String mimeType = this.extractMimeType(part.getContentType());
            InputStream is = (InputStream)content;
            FastByteArrayOutputStream fbaos = new FastByteArrayOutputStream();
            StreamUtil.copy((InputStream)is, (OutputStream)fbaos);
            email.addAttachment(fileName, mimeType, contentId, fbaos.toByteArray());
        }
    }

    protected String extractMimeType(String contentType) {
        int ndx = contentType.indexOf(59);
        String mime = ndx != -1 ? contentType.substring(0, ndx) : contentType;
        return mime;
    }

    protected String extractEncoding(String contentType) {
        int ndx = contentType.indexOf(59);
        String charset = ndx != -1 ? contentType.substring(ndx + 1) : "";
        String encoding = null;
        ndx = charset.indexOf(STR_CHARSET);
        if (ndx != -1) {
            char c;
            int len = charset.length();
            if (charset.charAt(ndx += STR_CHARSET.length()) == '\"') {
                ++ndx;
            }
            int start = ndx;
            while (ndx < len && (c = charset.charAt(ndx)) != '\"' && !CharUtil.isWhitespace((char)c)) {
                ++ndx;
            }
            encoding = charset.substring(start, ndx);
        }
        return encoding;
    }

    protected String[] address2String(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return null;
        }
        String[] res = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            res[i] = address.toString();
        }
        return res;
    }

    protected void closeFolderIfOpened() {
        if (this.folder != null) {
            try {
                this.folder.close(true);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.closeFolderIfOpened();
        try {
            this.store.close();
        }
        catch (MessagingException mex) {
            throw new MailException("Unable to close session", mex);
        }
    }
}

