/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import jodd.io.StringInputStream;
import jodd.mail.ReceivedEmail;
import jodd.util.CharUtil;

public class EmailUtil {
    protected static final String ATTR_CHARSET = "charset=";

    public static String extractMimeType(String contentType) {
        int ndx = contentType.indexOf(59);
        String mime = ndx != -1 ? contentType.substring(0, ndx) : contentType;
        return mime;
    }

    public static String extractEncoding(String contentType) {
        int ndx = contentType.indexOf(59);
        String charset = ndx != -1 ? contentType.substring(ndx + 1) : "";
        String encoding = null;
        ndx = charset.indexOf(ATTR_CHARSET);
        if (ndx != -1) {
            char c;
            int len = charset.length();
            if (charset.charAt(ndx += ATTR_CHARSET.length()) == '\"') {
                ++ndx;
            }
            int start = ndx;
            while (ndx < len && (c = charset.charAt(ndx)) != '\"' && !CharUtil.isWhitespace((char)c) && c != ';') {
                ++ndx;
            }
            encoding = charset.substring(start, ndx);
        }
        return encoding;
    }

    public static String[] address2String(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return null;
        }
        String[] res = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            res[i] = address.toString();
        }
        return res;
    }

    public static ReceivedEmail parseEML(File emlFile) throws FileNotFoundException, MessagingException {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session, (InputStream)new FileInputStream(emlFile));
        return new ReceivedEmail((Message)message);
    }

    public static ReceivedEmail parseEML(String emlContent) throws MessagingException {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session, (InputStream)new StringInputStream(emlContent, StringInputStream.Mode.ASCII));
        return new ReceivedEmail((Message)message);
    }
}

