/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.mail.EmailMessage;
import jodd.mail.MailAddress;
import jodd.util.ArraysUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonEmail {
    public static final String X_PRIORITY = "X-Priority";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    protected MailAddress from;
    protected MailAddress[] to = MailAddress.EMPTY_ARRAY;
    protected MailAddress[] replyTo = MailAddress.EMPTY_ARRAY;
    protected MailAddress[] cc = MailAddress.EMPTY_ARRAY;
    protected MailAddress[] bcc = MailAddress.EMPTY_ARRAY;
    protected String subject;
    protected String subjectEncoding;
    protected List<EmailMessage> messages = new ArrayList<EmailMessage>();
    protected Map<String, String> headers;
    protected Date sentDate;

    public void setFrom(MailAddress from) {
        this.from = from;
    }

    public MailAddress getFrom() {
        return this.from;
    }

    public void setTo(MailAddress ... tos) {
        if (tos == null) {
            tos = MailAddress.EMPTY_ARRAY;
        }
        this.to = tos;
    }

    public void addTo(MailAddress to) {
        this.to = (MailAddress[])ArraysUtil.append((Object[])this.to, (Object)to);
    }

    public MailAddress[] getTo() {
        return this.to;
    }

    public void setReplyTo(MailAddress ... replyTo) {
        if (replyTo == null) {
            replyTo = MailAddress.EMPTY_ARRAY;
        }
        this.replyTo = replyTo;
    }

    public void addReplyTo(MailAddress to) {
        this.replyTo = (MailAddress[])ArraysUtil.append((Object[])this.replyTo, (Object)to);
    }

    public MailAddress[] getReplyTo() {
        return this.replyTo;
    }

    public void setCc(MailAddress ... ccs) {
        if (ccs == null) {
            ccs = MailAddress.EMPTY_ARRAY;
        }
        this.cc = ccs;
    }

    public void addCc(MailAddress to) {
        this.cc = (MailAddress[])ArraysUtil.append((Object[])this.cc, (Object)to);
    }

    public MailAddress[] getCc() {
        return this.cc;
    }

    public void setBcc(MailAddress ... bccs) {
        if (bccs == null) {
            bccs = MailAddress.EMPTY_ARRAY;
        }
        this.bcc = bccs;
    }

    public void addBcc(MailAddress to) {
        this.bcc = (MailAddress[])ArraysUtil.append((Object[])this.bcc, (Object)to);
    }

    public MailAddress[] getBcc() {
        return this.bcc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSubject(String subject, String encoding) {
        this.subject = subject;
        this.subjectEncoding = encoding;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSubjectEncoding() {
        return this.subjectEncoding;
    }

    public List<EmailMessage> getAllMessages() {
        return this.messages;
    }

    public void addMessage(EmailMessage emailMessage) {
        this.messages.add(emailMessage);
    }

    public void addMessage(String text, String mimeType, String encoding) {
        this.messages.add(new EmailMessage(text, mimeType, encoding));
    }

    public void addMessage(String text, String mimeType) {
        this.messages.add(new EmailMessage(text, mimeType));
    }

    protected Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public void setPriority(int priority) {
        this.setHeader(X_PRIORITY, String.valueOf(priority));
    }

    public int getPriority() {
        if (this.headers == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.headers.get(X_PRIORITY));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        return this.sentDate;
    }
}

