/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import jodd.mail.SmtpServer;

public class SmtpSslServer
extends SmtpServer<SmtpSslServer> {
    public static final String MAIL_SMTP_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    protected static final int DEFAULT_SSL_PORT = 465;
    protected boolean startTlsRequired = false;
    protected boolean plaintextOverTLS = false;

    public static SmtpSslServer create(String host) {
        return new SmtpSslServer(host, 465);
    }

    public static SmtpSslServer create(String host, int port) {
        return new SmtpSslServer(host, port);
    }

    public SmtpSslServer(String host) {
        super(host, 465);
    }

    public SmtpSslServer(String host, int port) {
        super(host, port);
    }

    public SmtpSslServer startTlsRequired(boolean startTlsRequired) {
        this.startTlsRequired = startTlsRequired;
        return this;
    }

    public SmtpSslServer plaintextOverTLS(boolean plaintextOverTLS) {
        this.plaintextOverTLS = plaintextOverTLS;
        return this;
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty(MAIL_SMTP_STARTTLS_REQUIRED, this.startTlsRequired ? "true" : "false");
        props.setProperty(MAIL_SMTP_STARTTLS_ENABLE, "true");
        props.setProperty(MAIL_SMTP_SOCKET_FACTORY_PORT, String.valueOf(this.port));
        props.setProperty("mail.smtp.port", String.valueOf(this.port));
        if (!this.plaintextOverTLS) {
            props.setProperty(MAIL_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        }
        props.setProperty(MAIL_SMTP_SOCKET_FACTORY_FALLBACK, "false");
        props.setProperty("mail.host", this.host);
        return props;
    }
}

