/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailMessage;
import jodd.mail.MailException;
import jodd.util.net.MimeTypes;

public class EmailAttachmentBuilder {
    private String name;
    private String contentId;
    private boolean isInline = false;
    private DataSource dataSource;
    private EmailMessage targetMessage;

    protected EmailAttachmentBuilder() {
    }

    public EmailAttachmentBuilder name(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.name = name;
        }
        return this;
    }

    public EmailAttachmentBuilder contentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    public EmailAttachmentBuilder inline(boolean isInline) {
        this.isInline = isInline;
        return this;
    }

    public EmailAttachmentBuilder embeddedMessage(EmailMessage targetMessage) {
        this.targetMessage = targetMessage;
        return this;
    }

    public <T extends DataSource> EmailAttachmentBuilder content(T dataSource) {
        this.dataSource = dataSource;
        this.name(dataSource.getName());
        return this;
    }

    public EmailAttachmentBuilder content(InputStream inputStream, String contentType) throws IOException {
        return this.content(new ByteArrayDataSource(inputStream, this.resolveContentType(contentType)));
    }

    public EmailAttachmentBuilder content(byte[] bytes, String contentType) {
        return this.content(new ByteArrayDataSource(bytes, this.resolveContentType(contentType)));
    }

    public EmailAttachmentBuilder content(byte[] bytes) {
        return this.content(bytes, null);
    }

    public EmailAttachmentBuilder content(File file) {
        return this.content(new FileDataSource(file));
    }

    public EmailAttachmentBuilder content(String fileName) {
        return this.content(new File(fileName));
    }

    public EmailAttachment<ByteArrayDataSource> buildByteArrayDataSource() throws MailException {
        try {
            ByteArrayDataSource bads = this.dataSource instanceof ByteArrayDataSource ? (ByteArrayDataSource)this.dataSource : new ByteArrayDataSource(this.dataSource.getInputStream(), this.dataSource.getContentType());
            this.checkDataSource();
            return new EmailAttachment<ByteArrayDataSource>(this.name, this.contentId, this.isInline, bads).setEmbeddedMessage(this.targetMessage);
        }
        catch (IOException ioexc) {
            throw new MailException(ioexc);
        }
    }

    public EmailAttachment<FileDataSource> buildFileDataSource() throws MailException {
        try {
            FileDataSource fds;
            if (this.dataSource instanceof FileDataSource) {
                fds = (FileDataSource)this.dataSource;
            } else {
                File file = new File(this.dataSource.getName());
                FileUtil.writeStream((File)file, (InputStream)this.dataSource.getInputStream());
                fds = new FileDataSource(file);
            }
            this.checkDataSource();
            return new EmailAttachment<FileDataSource>(this.name, this.contentId, this.isInline, fds).setEmbeddedMessage(this.targetMessage);
        }
        catch (IOException ioexc) {
            throw new MailException(ioexc);
        }
    }

    private void checkDataSource() {
        if (this.dataSource == null) {
            throw new MailException("dataSource must be valid. It can be set using #content().");
        }
    }

    protected EmailAttachmentBuilder setContentIdFromNameIfMissing() {
        if (this.contentId == null) {
            if (this.name != null) {
                this.contentId(FileNameUtil.getName((String)this.name));
            } else {
                this.contentId("no-name");
            }
        }
        return this;
    }

    protected String resolveContentType(String contentType) {
        if (contentType != null) {
            return contentType;
        }
        if (this.name == null) {
            return "application/octet-stream";
        }
        String extension = FileNameUtil.getExtension((String)this.name);
        return MimeTypes.getMimeType((String)extension);
    }
}

