/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import com.sun.mail.imap.IMAPSSLStore;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import jodd.mail.ImapServer;
import jodd.mail.SimpleAuthenticator;

public class ImapSslServer
extends ImapServer {
    protected static final String MAIL_IMAP_SOCKET_FACTORY_PORT = "mail.imap.socketFactory.port";
    protected static final String MAIL_IMAP_SOCKET_FACTORY_CLASS = "mail.imap.socketFactory.class";
    protected static final String MAIL_IMAP_SOCKET_FACTORY_FALLBACK = "mail.imap.socketFactory.fallback";
    protected static final int DEFAULT_SSL_PORT = 993;

    public ImapSslServer(String host, int port, Authenticator authenticator) {
        super(host, port == -1 ? 993 : port, authenticator);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty(MAIL_IMAP_SOCKET_FACTORY_PORT, String.valueOf(this.getPort()));
        props.setProperty(MAIL_IMAP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        props.setProperty(MAIL_IMAP_SOCKET_FACTORY_FALLBACK, "false");
        return props;
    }

    protected IMAPSSLStore getStore(Session session) {
        URLName url;
        SimpleAuthenticator simpleAuthenticator = (SimpleAuthenticator)this.getAuthenticator();
        if (simpleAuthenticator == null) {
            url = new URLName("imap", this.getHost(), this.getPort(), "", null, null);
        } else {
            PasswordAuthentication pa = simpleAuthenticator.getPasswordAuthentication();
            url = new URLName("imap", this.getHost(), this.getPort(), "", pa.getUserName(), pa.getPassword());
        }
        return new IMAPSSLStore(session, url);
    }
}

