/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.mail.Authenticator;
import jodd.mail.ImapServer;
import jodd.mail.ImapSslServer;
import jodd.mail.MailSession;
import jodd.mail.Pop3Server;
import jodd.mail.Pop3SslServer;
import jodd.mail.SimpleAuthenticator;
import jodd.mail.SmtpServer;
import jodd.mail.SmtpSslServer;

public abstract class MailServer<MailSessionImpl extends MailSession> {
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_SMTP_CONNECTIONTIMEOUT = "mail.smtp.connectiontimeout";
    public static final String MAIL_SMTP_TIMEOUT = "mail.smtp.timeout";
    public static final String MAIL_SMTP_WRITETIMEOUT = "mail.smtp.writetimeout";
    public static final String MAIL_DEBUG = "mail.debug";
    public static final String MAIL_MIME_ADDRESS_STRICT = "mail.mime.address.strict";
    public static final String MAIL_IMAP_CONNECTIONTIMEOUT = "mail.imap.connectiontimeout";
    public static final String MAIL_IMAP_TIMEOUT = "mail.imap.timeout";
    public static final String MAIL_IMAP_PORT = "mail.imap.port";
    public static final String MAIL_IMAP_HOST = "mail.imap.host";
    public static final String MAIL_IMAP_PARTIALFETCH = "mail.imap.partialfetch";
    public static final String MAIL_IMAP_SOCKET_FACTORY_PORT = "mail.imap.socketFactory.port";
    public static final String MAIL_IMAP_SOCKET_FACTORY_CLASS = "mail.imap.socketFactory.class";
    public static final String MAIL_IMAP_SOCKET_FACTORY_FALLBACK = "mail.imap.socketFactory.fallback";
    public static final String MAIL_SMTP_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    public static final String MAIL_POP3_PORT = "mail.pop3.port";
    public static final String MAIL_POP3_HOST = "mail.pop3.host";
    public static final String MAIL_POP3_AUTH = "mail.pop3.auth";
    public static final String MAIL_POP3_CONNECTIONTIMEOUT = "mail.pop3.connectiontimeout";
    public static final String MAIL_POP3_TIMEOUT = "mail.pop3.timeout";
    public static final String MAIL_POP3_SOCKET_FACTORY_PORT = "mail.pop3.socketFactory.port";
    public static final String MAIL_POP3_SOCKET_FACTORY_CLASS = "mail.pop3.socketFactory.class";
    public static final String MAIL_POP3_SOCKET_FACTORY_FALLBACK = "mail.pop3.socketFactory.fallback";
    protected final String host;
    protected final int port;
    protected final Authenticator authenticator;
    protected final File attachmentStorage;
    protected final boolean debugMode;
    protected final boolean strictAddress;
    protected final int timeout;
    protected final Properties customProperties;

    protected MailServer(Builder builder, int defaultPort) {
        Objects.requireNonNull(builder.host, "Host cannot be null");
        this.host = builder.host;
        this.port = builder.port == -1 ? defaultPort : builder.port;
        this.authenticator = builder.authenticator;
        this.attachmentStorage = builder.attachmentStorage;
        this.timeout = builder.timeout;
        this.strictAddress = builder.strictAddress;
        this.debugMode = builder.debug;
        this.customProperties = builder.customProperties;
    }

    public abstract MailSessionImpl createSession();

    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.customProperties);
        if (this.debugMode) {
            props.put(MAIL_DEBUG, "true");
        }
        if (!this.strictAddress) {
            props.put(MAIL_MIME_ADDRESS_STRICT, "false");
        }
        return props;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private String host = null;
        private int port = -1;
        private boolean ssl = false;
        private Authenticator authenticator;
        private File attachmentStorage;
        private boolean debug;
        private int timeout = 0;
        private boolean strictAddress = true;
        private Properties customProperties = new Properties();

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder storeAttachmentsIn(File attachmentStorage) {
            this.attachmentStorage = attachmentStorage;
            return this;
        }

        public Builder auth(String username, String password) {
            Objects.requireNonNull(username, "Username cannot be null");
            Objects.requireNonNull(password, "Password cannot be null");
            return this.auth(new SimpleAuthenticator(username, password));
        }

        public Builder auth(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder debugMode(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder strictAddress(boolean strictAddress) {
            this.strictAddress = strictAddress;
            return this;
        }

        public Builder property(String name, String value) {
            this.customProperties.put(name, value);
            return this;
        }

        public ImapServer buildImapMailServer() {
            if (this.ssl) {
                return new ImapSslServer(this);
            }
            return new ImapServer(this);
        }

        public Pop3Server buildPop3MailServer() {
            if (this.ssl) {
                return new Pop3SslServer(this);
            }
            return new Pop3Server(this);
        }

        public SmtpServer buildSmtpMailServer() {
            if (this.ssl) {
                return new SmtpSslServer(this);
            }
            return new SmtpServer(this);
        }
    }
}

