/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Header;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.mail.EmailAddress;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailAttachmentBuilder;
import jodd.mail.EmailMessage;
import jodd.util.ArraysUtil;

public abstract class CommonEmail<T extends CommonEmail<T>> {
    public static final String X_PRIORITY = "X-Priority";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    private EmailAddress from;
    private EmailAddress[] to = EmailAddress.EMPTY_ARRAY;
    private EmailAddress[] replyTo = EmailAddress.EMPTY_ARRAY;
    private EmailAddress[] cc = EmailAddress.EMPTY_ARRAY;
    private String subject;
    private String subjectEncoding;
    private final List<EmailMessage> messages = new ArrayList<EmailMessage>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final List<EmailAttachment<? extends DataSource>> attachments = new ArrayList<EmailAttachment<? extends DataSource>>();
    private Date sentDate;

    protected T _this() {
        return (T)this;
    }

    public abstract T clone();

    public T from(EmailAddress from) {
        this.from = from;
        return this._this();
    }

    public T from(Address from) {
        return this.from(EmailAddress.of(from));
    }

    public T from(String from) {
        return this.from(EmailAddress.of(from));
    }

    public T from(String personalName, String from) {
        return this.from(new EmailAddress(personalName, from));
    }

    public EmailAddress from() {
        return this.from;
    }

    public T to(EmailAddress to) {
        this.to = (EmailAddress[])ArraysUtil.append((Object[])this.to, (Object)to);
        return this._this();
    }

    public T to(String to) {
        return this.to(EmailAddress.of(to));
    }

    public T to(String personalName, String to) {
        return this.to(new EmailAddress(personalName, to));
    }

    public T to(Address to) {
        return this.to(EmailAddress.of(to));
    }

    public T to(String ... tos) {
        return this.to(EmailAddress.of(tos));
    }

    public T to(Address ... tos) {
        return this.to(EmailAddress.of(tos));
    }

    public T to(EmailAddress ... tos) {
        this.to = this.valueOrEmptyArray(tos);
        return this._this();
    }

    public EmailAddress[] to() {
        return this.to;
    }

    public T resetTo() {
        this.to = EmailAddress.EMPTY_ARRAY;
        return this._this();
    }

    public T replyTo(EmailAddress replyTo) {
        this.replyTo = (EmailAddress[])ArraysUtil.append((Object[])this.replyTo, (Object)replyTo);
        return this._this();
    }

    public T replyTo(String replyTo) {
        return this.replyTo(EmailAddress.of(replyTo));
    }

    public T replyTo(String personalName, String replyTo) {
        return this.replyTo(new EmailAddress(personalName, replyTo));
    }

    public T replyTo(Address replyTo) {
        return this.replyTo(EmailAddress.of(replyTo));
    }

    public T replyTo(String ... replyTos) {
        return this.replyTo(EmailAddress.of(replyTos));
    }

    public T replyTo(Address ... replyTos) {
        return this.replyTo(EmailAddress.of(replyTos));
    }

    public T replyTo(EmailAddress ... replyTo) {
        this.replyTo = (EmailAddress[])ArraysUtil.join((Object[][])new EmailAddress[][]{this.replyTo, this.valueOrEmptyArray(replyTo)});
        return this._this();
    }

    public EmailAddress[] replyTo() {
        return this.replyTo;
    }

    public T resetReplyTo() {
        this.replyTo = EmailAddress.EMPTY_ARRAY;
        return this._this();
    }

    public T cc(EmailAddress to) {
        this.cc = (EmailAddress[])ArraysUtil.append((Object[])this.cc, (Object)to);
        return this._this();
    }

    public T cc(String cc) {
        return this.cc(EmailAddress.of(cc));
    }

    public T cc(String personalName, String cc) {
        return this.cc(new EmailAddress(personalName, cc));
    }

    public T cc(Address cc) {
        return this.cc(EmailAddress.of(cc));
    }

    public T cc(String ... ccs) {
        return this.cc(EmailAddress.of(ccs));
    }

    public T cc(Address ... ccs) {
        return this.cc(EmailAddress.of(ccs));
    }

    public T cc(EmailAddress ... ccs) {
        this.cc = (EmailAddress[])ArraysUtil.join((Object[][])new EmailAddress[][]{this.cc, this.valueOrEmptyArray(ccs)});
        return this._this();
    }

    public EmailAddress[] cc() {
        return this.cc;
    }

    public T resetCc() {
        this.cc = EmailAddress.EMPTY_ARRAY;
        return this._this();
    }

    public T subject(String subject) {
        this.subject = subject;
        return this._this();
    }

    public T subject(String subject, String encoding) {
        this.subject(subject);
        this.subjectEncoding = encoding;
        return this._this();
    }

    public String subject() {
        return this.subject;
    }

    public String subjectEncoding() {
        return this.subjectEncoding;
    }

    public List<EmailMessage> messages() {
        return this.messages;
    }

    public T message(List<EmailMessage> msgsToAdd) {
        this.messages.addAll(msgsToAdd);
        return this._this();
    }

    public T message(EmailMessage msgToAdd) {
        this.messages.add(msgToAdd);
        return this._this();
    }

    public T message(String text, String mimeType, String encoding) {
        return this.message(new EmailMessage(text, mimeType, encoding));
    }

    public T message(String text, String mimeType) {
        return this.message(new EmailMessage(text, mimeType));
    }

    public T textMessage(String text) {
        return this.message(text, "text/plain");
    }

    public T textMessage(String text, String encoding) {
        return this.message(new EmailMessage(text, "text/plain", encoding));
    }

    public T htmlMessage(String html) {
        return this.message(new EmailMessage(html, "text/html"));
    }

    public T htmlMessage(String html, String encoding) {
        return this.message(new EmailMessage(html, "text/html", encoding));
    }

    protected Map<String, String> headers() {
        return this.headers;
    }

    public T header(String name, String value) {
        this.headers.put(name, value);
        return this._this();
    }

    public T headers(Map<String, String> headersToSet) {
        this.headers.putAll(headersToSet);
        return this._this();
    }

    public T headers(Enumeration<Header> headersToSet) {
        while (headersToSet.hasMoreElements()) {
            Header header = headersToSet.nextElement();
            this.header(header.getName(), header.getValue());
        }
        return this._this();
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public T priority(int priority) {
        this.header(X_PRIORITY, String.valueOf(priority));
        return this._this();
    }

    public int priority() {
        try {
            return Integer.parseInt(this.headers.get(X_PRIORITY));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public List<EmailAttachment<? extends DataSource>> attachments() {
        return this.attachments;
    }

    protected T storeAttachments(List<EmailAttachment<? extends DataSource>> attachments) {
        this.attachments.addAll(attachments);
        return this._this();
    }

    protected T storeAttachment(EmailAttachment<? extends DataSource> attachment) {
        this.attachments.add(attachment);
        return this._this();
    }

    public T attachments(List<EmailAttachment<? extends DataSource>> attachments) {
        for (EmailAttachment<? extends DataSource> attachment : attachments) {
            this.attachment(attachment);
        }
        return this._this();
    }

    public T attachment(EmailAttachment<? extends DataSource> attachment) {
        attachment.setContentId(null);
        return this.storeAttachment(attachment);
    }

    public T attachment(EmailAttachmentBuilder builder) {
        return this.attachment(builder.buildByteArrayDataSource());
    }

    public T embeddedAttachment(EmailAttachmentBuilder builder) {
        builder.setContentIdFromNameIfMissing();
        builder.inline(true);
        return this.embeddedAttachment(builder.buildByteArrayDataSource());
    }

    public T embeddedAttachment(EmailAttachment<? extends DataSource> attachment) {
        this.storeAttachment(attachment);
        List<EmailMessage> messages = this.messages();
        int size = messages.size();
        if (size > 1) {
            int lastMessagePos = size - 1;
            EmailMessage lastMessage = messages.get(lastMessagePos);
            attachment.setEmbeddedMessage(lastMessage);
        }
        return this._this();
    }

    public T sentDate(Date date) {
        this.sentDate = date;
        return this._this();
    }

    public Date sentDate() {
        return this.sentDate;
    }

    public String toString() {
        return "Email{'" + this.from() + "', subject='" + this.subject() + "'}";
    }

    protected EmailAddress[] valueOrEmptyArray(EmailAddress[] arr) {
        if (arr == null) {
            arr = EmailAddress.EMPTY_ARRAY;
        }
        return arr;
    }
}

