/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import jodd.io.IOUtil;
import jodd.mail.EMLProperties;
import jodd.mail.ReceivedEmail;

public class EMLParser
extends EMLProperties<EMLParser> {
    public static EMLParser create() {
        return new EMLParser();
    }

    public ReceivedEmail parse(String emlContent, String charset) throws UnsupportedEncodingException, MessagingException {
        byte[] bytes = emlContent.getBytes(charset);
        return this.parse(bytes);
    }

    public ReceivedEmail parse(String emlContent) throws MessagingException {
        try {
            return this.parse(emlContent, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public ReceivedEmail parse(byte[] content) throws MessagingException {
        return this.parse(new ByteArrayInputStream(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceivedEmail parse(File emlFile) throws FileNotFoundException, MessagingException {
        FileInputStream fileInputStream = new FileInputStream(emlFile);
        try {
            ReceivedEmail receivedEmail = this.parse(fileInputStream);
            return receivedEmail;
        }
        finally {
            IOUtil.close((Closeable)fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReceivedEmail parse(InputStream emlContentInputStream) throws MessagingException {
        if (this.getSession() == null) {
            this.createSession(this.getProperties());
        }
        try {
            MimeMessage message = new MimeMessage(this.getSession(), emlContentInputStream);
            ReceivedEmail receivedEmail = new ReceivedEmail((Message)message, false, null);
            return receivedEmail;
        }
        finally {
            IOUtil.close((Closeable)emlContentInputStream);
        }
    }
}

