/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.Authenticator;
import jakarta.mail.Flags;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.function.Consumer;
import jodd.mail.MailException;
import jodd.mail.ReceiveMailSession;
import jodd.util.CharUtil;

public class EmailUtil {
    protected static final String ATTR_CHARSET = "charset=";
    static final String NO_NAME = "no-name";

    public static String extractMimeType(String contentType) {
        int ndx = contentType.indexOf(59);
        String mime = ndx != -1 ? contentType.substring(0, ndx) : contentType;
        return mime;
    }

    public static String extractEncoding(String contentType) {
        int ndx = contentType.indexOf(59);
        String charset = ndx != -1 ? contentType.substring(ndx + 1) : "";
        String encoding = null;
        ndx = charset.indexOf(ATTR_CHARSET);
        if (ndx != -1) {
            char c;
            int len = charset.length();
            if (charset.charAt(ndx += ATTR_CHARSET.length()) == '\"') {
                ++ndx;
            }
            int start = ndx;
            while (ndx < len && (c = charset.charAt(ndx)) != '\"' && !CharUtil.isWhitespace((char)c) && c != ';') {
                ++ndx;
            }
            encoding = charset.substring(start, ndx);
        }
        return encoding;
    }

    public static String extractEncoding(String contentType, String defaultEncoding) {
        String encoding = EmailUtil.extractEncoding(contentType);
        if (encoding == null) {
            if (defaultEncoding == null) {
                defaultEncoding = "UTF-8";
            }
            encoding = defaultEncoding;
        }
        return encoding;
    }

    public static String resolveFileName(Part part) throws MessagingException {
        String ret;
        if (!(part instanceof MimeBodyPart)) {
            return part.getFileName();
        }
        String contentType = part.getContentType();
        try {
            ret = MimeUtility.decodeText((String)part.getFileName());
        }
        catch (Exception ex) {
            String contentId = ((MimeBodyPart)part).getContentID();
            ret = contentId != null ? contentId + EmailUtil.contentTypeForFileName(contentType) : EmailUtil.defaultFileName(contentType);
        }
        return ret;
    }

    private static String contentTypeForFileName(String contentType) {
        return "." + contentType.substring(contentType.lastIndexOf("/") + 1, contentType.length());
    }

    private static String defaultFileName(String contentType) {
        return NO_NAME + EmailUtil.contentTypeForFileName(contentType);
    }

    public static ReceiveMailSession createSession(String protocol, Properties sessionProperties, Authenticator authenticator, File attachmentStorage, final Consumer<String> debugConsumer) {
        Store store;
        Session session = Session.getInstance((Properties)sessionProperties, (Authenticator)authenticator);
        if (debugConsumer != null) {
            session.setDebugOut(new PrintStream(new ByteArrayOutputStream(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() throws IOException {
                    1 var2_1 = this;
                    synchronized (var2_1) {
                        super.flush();
                        String record = this.toString().trim();
                        super.reset();
                        if (record.length() == 0 || record.equals(System.lineSeparator())) {
                            return;
                        }
                        debugConsumer.accept(record);
                    }
                }
            }, true));
        }
        try {
            store = session.getStore(protocol);
        }
        catch (NoSuchProviderException nspex) {
            String errMsg = String.format("Failed to create %s session", protocol);
            throw new MailException(errMsg, nspex);
        }
        return new ReceiveMailSession(session, store, attachmentStorage);
    }

    public static boolean isEmptyFlags(Flags flags) {
        if (flags == null) {
            return true;
        }
        Flags.Flag[] systemFlags = flags.getSystemFlags();
        if (systemFlags != null && systemFlags.length > 0) {
            return false;
        }
        String[] userFlags = flags.getUserFlags();
        return userFlags == null || userFlags.length <= 0;
    }
}

