/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.URLName;
import java.util.Properties;
import jodd.mail.MailServer;
import jodd.mail.Pop3Server;
import jodd.mail.SimpleAuthenticator;
import org.eclipse.angus.mail.pop3.POP3SSLStore;

public class Pop3SslServer
extends Pop3Server {
    protected static final int DEFAULT_SSL_PORT = 995;

    public Pop3SslServer(MailServer.Builder builder) {
        super(builder, 995);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty("mail.pop3.socketFactory.port", String.valueOf(this.port));
        props.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.pop3.socketFactory.fallback", "false");
        return props;
    }

    protected POP3SSLStore getStore(Session session) {
        URLName url;
        SimpleAuthenticator simpleAuthenticator = (SimpleAuthenticator)this.authenticator;
        if (simpleAuthenticator == null) {
            url = new URLName("pop3", this.host, this.port, "", null, null);
        } else {
            PasswordAuthentication pa = simpleAuthenticator.getPasswordAuthentication();
            url = new URLName("pop3", this.host, this.port, "", pa.getUserName(), pa.getPassword());
        }
        return new POP3SSLStore(session, url);
    }
}

