/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.Flags;
import jakarta.mail.MessagingException;
import java.util.function.Consumer;
import jodd.mail.EmailFilter;
import jodd.mail.MailException;
import jodd.mail.ReceiveMailSession;
import jodd.mail.ReceivedEmail;
import jodd.mail.ReceivedEmails;

public class ReceiverBuilder {
    private final ReceiveMailSession session;
    private EmailFilter filter;
    private final Flags flagsToSet = new Flags();
    private final Flags flagsToUnset = new Flags();
    private boolean envelopeOnly;
    private String targetFolder;
    private String fromFolder;

    public ReceiverBuilder(ReceiveMailSession session) {
        this.session = session;
    }

    public ReceiverBuilder filter(EmailFilter emailFilter) {
        this.filter = emailFilter;
        return this;
    }

    public ReceiverBuilder markSeen() {
        this.flagsToSet.add(Flags.Flag.SEEN);
        return this;
    }

    public ReceiverBuilder mark(Flags.Flag flagToSet) {
        this.flagsToSet.add(flagToSet);
        return this;
    }

    public ReceiverBuilder unmark(Flags.Flag flagToUnset) {
        this.flagsToUnset.add(flagToUnset);
        return this;
    }

    public ReceiverBuilder markDeleted() {
        this.flagsToSet.add(Flags.Flag.DELETED);
        return this;
    }

    public ReceiverBuilder fromFolder(String fromFolder) {
        this.fromFolder = fromFolder;
        return this;
    }

    public ReceiverBuilder moveToFolder(String targetFolder) {
        this.markDeleted();
        this.targetFolder = targetFolder;
        return this;
    }

    public ReceiverBuilder envelopeOnly() {
        this.envelopeOnly = true;
        return this;
    }

    public ReceivedEmail[] get() {
        return this.with(ReceiverRunner.EMPTY_CONSUMER).fetch();
    }

    public ReceiverRunner with(Consumer<ReceivedEmails> consumer) {
        if (this.fromFolder != null) {
            this.session.useFolder(this.fromFolder);
        }
        ReceivedEmails receivedEmails = this.session.receiveMessages(this.filter, this.flagsToSet, this.flagsToUnset, this.envelopeOnly, messages -> {
            if (this.targetFolder != null) {
                try {
                    this.session.folder.copyMessages(messages, this.session.getFolder(this.targetFolder));
                }
                catch (MessagingException e) {
                    throw new MailException("Copying messages failed");
                }
            }
        });
        return new ReceiverRunner(receivedEmails, consumer);
    }

    public static class ReceiverRunner {
        private final ReceivedEmails receivedEmails;
        private final Consumer<ReceivedEmails> consumer;
        private static final Consumer<ReceivedEmails> EMPTY_CONSUMER = receivedEmails -> {};

        private ReceiverRunner(ReceivedEmails receivedEmails, Consumer<ReceivedEmails> consumer) {
            this.receivedEmails = receivedEmails;
            this.consumer = consumer;
        }

        final ReceiverRunner run() {
            this.consumer.accept(this.receivedEmails);
            return this;
        }

        final ReceivedEmail[] fetch() {
            return this.receivedEmails.fetch();
        }
    }
}

