/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Service;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jodd.mail.Email;
import jodd.mail.EmailAddress;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailMessage;
import jodd.mail.MailException;
import jodd.mail.MailSession;

public class SendMailSession
extends MailSession<Transport> {
    private static final String ALTERNATIVE = "alternative";
    private static final String RELATED = "related";
    private static final String CHARSET = ";charset=";
    private static final String INLINE = "inline";

    public SendMailSession(Session session, Transport transport) {
        super(session, (Service)transport);
    }

    @Override
    public Transport getService() {
        return (Transport)this.service;
    }

    public String sendMail(Email email) {
        try {
            MimeMessage msg = this.createMessage(email);
            this.getService().sendMessage((Message)msg, msg.getAllRecipients());
            return msg.getMessageID();
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to send email: " + email, msgexc);
        }
    }

    protected MimeMessage createMessage(Email email) throws MessagingException {
        Email clone = email.clone();
        MimeMessage newMsg = new MimeMessage(this.getSession());
        this.setPeople(clone, newMsg);
        SendMailSession.setSubject(clone, newMsg);
        SendMailSession.setSentDate(clone, newMsg);
        SendMailSession.setHeaders(clone, newMsg);
        this.addBodyData(clone, newMsg);
        return newMsg;
    }

    private static void setSubject(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        if (emailWithData.subjectEncoding() != null) {
            msgToSet.setSubject(emailWithData.subject(), emailWithData.subjectEncoding());
        } else {
            msgToSet.setSubject(emailWithData.subject());
        }
    }

    private static void setSentDate(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        Date date = emailWithData.sentDate();
        if (date == null) {
            date = new Date();
        }
        msgToSet.setSentDate(date);
    }

    private static void setHeaders(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        Map<String, String> headers = emailWithData.headers();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                msgToSet.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setPeople(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        msgToSet.setFrom((Address)emailWithData.from().toInternetAddress());
        msgToSet.setReplyTo((Address[])EmailAddress.convert(emailWithData.replyTo()));
        this.setRecipients(emailWithData, msgToSet);
    }

    private void setRecipients(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        InternetAddress[] bcc;
        InternetAddress[] cc;
        InternetAddress[] to = EmailAddress.convert(emailWithData.to());
        if (to.length > 0) {
            msgToSet.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        if ((cc = EmailAddress.convert(emailWithData.cc())).length > 0) {
            msgToSet.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if ((bcc = EmailAddress.convert(emailWithData.bcc())).length > 0) {
            msgToSet.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
    }

    private void addBodyData(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        List<EmailMessage> messages = emailWithData.messages();
        int totalMessages = messages.size();
        ArrayList<EmailAttachment<? extends DataSource>> attachments = new ArrayList<EmailAttachment<? extends DataSource>>(emailWithData.attachments());
        if (attachments.isEmpty() && totalMessages == 1) {
            SendMailSession.setContent(messages.get(0), (Part)msgToSet);
        } else {
            MimeMultipart multipart = new MimeMultipart();
            MimeMultipart msgMultipart = new MimeMultipart(ALTERNATIVE);
            multipart.addBodyPart((BodyPart)SendMailSession.getBaseBodyPart(msgMultipart));
            for (EmailMessage emailMessage : messages) {
                msgMultipart.addBodyPart((BodyPart)this.getBodyPart(emailMessage, attachments));
            }
            this.addAnyAttachments(attachments, multipart);
            msgToSet.setContent((Multipart)multipart);
        }
    }

    private static MimeBodyPart getBaseBodyPart(MimeMultipart msgMultipart) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Multipart)msgMultipart);
        return bodyPart;
    }

    private MimeBodyPart getBodyPart(EmailMessage emailMessage, List<EmailAttachment<? extends DataSource>> attachments) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        List<EmailAttachment<? extends DataSource>> embeddedAttachments = SendMailSession.filterEmbeddedAttachments(attachments, emailMessage);
        if (embeddedAttachments.isEmpty()) {
            SendMailSession.setContent(emailMessage, (Part)bodyPart);
        } else {
            attachments.removeAll(embeddedAttachments);
            MimeMultipart relatedMultipart = new MimeMultipart(RELATED);
            MimeBodyPart messageData = new MimeBodyPart();
            SendMailSession.setContent(emailMessage, (Part)messageData);
            relatedMultipart.addBodyPart((BodyPart)messageData);
            this.addAnyAttachments(embeddedAttachments, relatedMultipart);
            bodyPart.setContent((Multipart)relatedMultipart);
        }
        return bodyPart;
    }

    private static void setContent(EmailMessage emailWithData, Part partToSet) throws MessagingException {
        partToSet.setContent((Object)emailWithData.getContent(), emailWithData.getMimeType() + CHARSET + emailWithData.getEncoding());
    }

    protected MimeBodyPart createAttachmentBodyPart(EmailAttachment<? extends DataSource> attachment) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        String attachmentName = attachment.getEncodedName();
        if (attachmentName != null) {
            part.setFileName(attachmentName);
        }
        part.setDataHandler(new DataHandler(attachment.getDataSource()));
        if (attachment.getContentId() != null) {
            part.setContentID("<" + attachment.getContentId() + ">");
        }
        if (attachment.isInline()) {
            part.setDisposition(INLINE);
        }
        return part;
    }

    protected static List<EmailAttachment<? extends DataSource>> filterEmbeddedAttachments(List<EmailAttachment<? extends DataSource>> attachments, EmailMessage emailMessage) {
        ArrayList<EmailAttachment<? extends DataSource>> embeddedAttachments = new ArrayList<EmailAttachment<? extends DataSource>>();
        if (attachments == null || attachments.isEmpty() || emailMessage == null) {
            return embeddedAttachments;
        }
        Iterator<EmailAttachment<? extends DataSource>> iterator = attachments.iterator();
        while (iterator.hasNext()) {
            EmailAttachment<? extends DataSource> emailAttachment = iterator.next();
            if (!emailAttachment.isEmbeddedInto(emailMessage)) continue;
            embeddedAttachments.add(emailAttachment);
            iterator.remove();
        }
        return embeddedAttachments;
    }

    private void addAnyAttachments(List<EmailAttachment<? extends DataSource>> attachments, MimeMultipart multipart) throws MessagingException {
        for (EmailAttachment<? extends DataSource> attachment : attachments) {
            MimeBodyPart bodyPart = this.createAttachmentBodyPart(attachment);
            multipart.addBodyPart((BodyPart)bodyPart);
        }
    }

    static {
        SendMailSession.setupSystemMailProperties();
    }
}

